/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.block.CatTreeBlock;
import com.github.mnesikos.simplycats.block.CatnipBlock;
import com.github.mnesikos.simplycats.block.LitterBoxBlock;
import com.github.mnesikos.simplycats.block.ScratchingPostBlock;
import com.github.mnesikos.simplycats.block.ShelterBookBlock;
import com.github.mnesikos.simplycats.block.WindowPerchBlock;
import com.github.mnesikos.simplycats.item.SCItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SCBlocks {
    public static final DeferredRegister<Block> REGISTRAR;
    public static final RegistryObject<Block> CATNIP_CROP;
    public static final RegistryObject<Block> SHELTER_BOOK;
    public static final Map<DyeColor, RegistryObject<Block>> LITTER_BOXES;
    public static final Map<DyeColor, RegistryObject<Block>> CAT_TREE_BEDS;
    public static final Map<DyeColor, RegistryObject<Block>> CAT_TREE_POSTS;
    public static final Map<DyeColor, RegistryObject<Block>> CAT_TREE_BOXES;
    public static final Map<String, RegistryObject<Block>> SCRATCHING_POSTS;
    public static final Map<String, RegistryObject<Block>> WINDOW_PERCHES;

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        RegistryObject registryObject = REGISTRAR.register(name, block);
        SCItems.REGISTRAR.register(name, () -> new BlockItem((Block)registryObject.get(), new Item.Properties().func_200916_a(SimplyCats.ITEM_GROUP)));
        return registryObject;
    }

    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            RenderTypeLookup.setRenderLayer((Block)((Block)CATNIP_CROP.get()), (RenderType)RenderType.func_228643_e_());
        }
    }

    static {
        String[] woodTypes;
        REGISTRAR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"simplycats");
        CATNIP_CROP = REGISTRAR.register("catnip", () -> new CatnipBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150464_aj)));
        SHELTER_BOOK = SCBlocks.register("shelter_book", ShelterBookBlock::new);
        LITTER_BOXES = new HashMap<DyeColor, RegistryObject<Block>>();
        CAT_TREE_BEDS = new HashMap<DyeColor, RegistryObject<Block>>();
        CAT_TREE_POSTS = new HashMap<DyeColor, RegistryObject<Block>>();
        CAT_TREE_BOXES = new HashMap<DyeColor, RegistryObject<Block>>();
        SCRATCHING_POSTS = new HashMap<String, RegistryObject<Block>>();
        WINDOW_PERCHES = new HashMap<String, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            LITTER_BOXES.put(color, SCBlocks.register(color.func_176762_d() + "_litter_box", LitterBoxBlock::new));
            CAT_TREE_BEDS.put(color, SCBlocks.register(color.func_176762_d() + "_cat_tree_bed", () -> new CatTreeBlock.Bed(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0))));
            CAT_TREE_POSTS.put(color, SCBlocks.register(color.func_176762_d() + "_cat_tree_post", () -> new CatTreeBlock(Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0))));
            CAT_TREE_BOXES.put(color, SCBlocks.register(color.func_176762_d() + "_cat_tree_box", CatTreeBlock.Box::new));
        }
        for (String woodType : woodTypes = new String[]{"oak", "spruce", "birch", "acacia", "jungle", "dark_oak", "crimson", "warped"}) {
            SCRATCHING_POSTS.put(woodType, SCBlocks.register(woodType + "_scratching_post", ScratchingPostBlock::new));
            WINDOW_PERCHES.put(woodType, SCBlocks.register(woodType + "_window_perch", WindowPerchBlock::new));
        }
    }
}

