/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.render.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;

@OnlyIn(value=Dist.CLIENT)
public class LayeredTexture
extends Texture {
    public final String[] texturePaths;

    public LayeredTexture(String[] texturePaths) {
        this.texturePaths = texturePaths;
        if (this.texturePaths.length <= 0) {
            throw new IllegalStateException("No textures provided.");
        }
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        NativeImage image = this.getLayer(manager, this.texturePaths);
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.loadImage(image));
        } else {
            this.loadImage(image);
        }
    }

    public NativeImage getLayer(IResourceManager manager, String[] texturePaths) {
        List<String> layers = Arrays.asList(texturePaths);
        Iterator<String> iterator = layers.iterator();
        String baseLayer = iterator.next();
        NativeImage baseImage = this.tryLayer(manager, baseLayer);
        if (baseImage == null) {
            return null;
        }
        while (iterator.hasNext()) {
            NativeImage image;
            String layer = iterator.next();
            if (layer == null || (image = this.tryLayer(manager, layer)) == null) continue;
            this.blendLayer(baseImage, image);
        }
        return baseImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NativeImage tryLayer(IResourceManager manager, String layer) {
        if (layer == null) {
            return null;
        }
        try (IResource resource = manager.func_199002_a(new ResourceLocation(layer));){
            NativeImage image;
            NativeImage nativeImage = image = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(layer), (IResourceManager)manager);
            return nativeImage;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Couldn't load texture layers.", exception);
        }
    }

    public void blendLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = image.func_195709_a(j, i);
                this.blendPixel(base, j, i, NativeImage.func_227787_a_((int)NativeImage.func_227786_a_((int)color), (int)NativeImage.func_227795_d_((int)color), (int)NativeImage.func_227793_c_((int)color), (int)NativeImage.func_227791_b_((int)color)));
            }
        }
    }

    private void loadImage(NativeImage image) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)image.func_195702_a(), (int)image.func_195714_b());
        image.func_195697_a(0, 0, 0, true);
    }

    public void blendPixel(NativeImage image, int x, int y, int color) {
        int baseColor = image.func_195709_a(x, y);
        float a = (float)NativeImage.func_227786_a_((int)color) / 255.0f;
        float blue = NativeImage.func_227795_d_((int)color);
        float green = NativeImage.func_227793_c_((int)color);
        float red = NativeImage.func_227791_b_((int)color);
        float baseAlpha = (float)NativeImage.func_227786_a_((int)baseColor) / 255.0f;
        float baseBlue = NativeImage.func_227795_d_((int)baseColor);
        float baseGreen = NativeImage.func_227793_c_((int)baseColor);
        float baseRed = NativeImage.func_227791_b_((int)baseColor);
        float alph = a * a + baseAlpha * (1.0f - a);
        int finalAlpha = (int)(alph * 255.0f);
        int finalBlue = (int)(blue * a + baseBlue * (1.0f - a));
        int finalGreen = (int)(green * a + baseGreen * (1.0f - a));
        int finalRed = (int)(red * a + baseRed * (1.0f - a));
        if (finalAlpha > 255) {
            finalAlpha = 255;
        }
        if (finalBlue > 255) {
            finalBlue = 255;
        }
        if (finalGreen > 255) {
            finalGreen = 255;
        }
        if (finalRed > 255) {
            finalRed = 255;
        }
        image.func_195700_a(x, y, NativeImage.func_227787_a_((int)finalAlpha, (int)finalBlue, (int)finalGreen, (int)finalRed));
    }
}

