/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.goal;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class CatBirthGoal
extends Goal {
    private final SimplyCatEntity mother;
    private SimplyCatEntity father;
    World level;

    public CatBirthGoal(SimplyCatEntity catEntity) {
        this.mother = catEntity;
        this.level = catEntity.field_70170_p;
    }

    public boolean func_75250_a() {
        if (this.mother.getSex() != Genetics.Sex.FEMALE || !this.mother.getBreedingStatus("ispregnant") || this.mother.getBreedingStatus("inheat")) {
            return false;
        }
        if (this.mother.getMateTimer() >= 0) {
            return false;
        }
        return !this.mother.func_70909_n() || this.mother.func_70902_q() != null;
    }

    public boolean func_75253_b() {
        return this.mother.getBreedingStatus("ispregnant");
    }

    public void func_75251_c() {
        this.father = null;
    }

    public void func_75246_d() {
        for (int i = 0; i < this.mother.getKittens(); ++i) {
            this.father = new SimplyCatEntity((EntityType<? extends TameableEntity>)((EntityType)SimplyCats.CAT.get()), this.level);
            this.father.func_70020_e(this.mother.getFather(i));
            this.spawnBaby(this.father);
            this.mother.getPersistentData().func_82580_o("Father" + i);
        }
        this.mother.setKittens(0);
        this.mother.setBreedingStatus("ispregnant", false);
        this.mother.setTimeCycle("end", (Integer)SCConfig.Common.heat_cooldown.get());
    }

    private void spawnBaby(SimplyCatEntity father) {
        ServerWorld serverWorld = (ServerWorld)this.level;
        SimplyCatEntity child = (SimplyCatEntity)this.mother.func_241840_a(serverWorld, (AgeableEntity)father);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)this.mother, (MobEntity)father, (AgeableEntity)child);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        child = (SimplyCatEntity)event.getChild();
        if (cancelled) {
            return;
        }
        if (child != null) {
            child.func_70873_a(-((Integer)SCConfig.Common.kitten_mature_timer.get()).intValue());
            child.setMatureTimer(((Integer)SCConfig.Common.kitten_mature_timer.get()).intValue());
            child.func_70012_b(this.mother.func_226277_ct_(), this.mother.func_226278_cu_(), this.mother.func_226281_cx_(), 0.0f, 0.0f);
            child.setFather(this.father.func_110124_au());
            child.setMother(this.mother.func_110124_au());
            serverWorld.func_242417_l((Entity)child);
            serverWorld.func_72960_a((Entity)this.mother, (byte)18);
            Random random = this.mother.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                this.level.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.mother.func_226282_d_(1.0), this.mother.func_226279_cv_() + 0.5, this.mother.func_226287_g_(1.0), d0, d1, d2);
            }
            if (serverWorld.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                serverWorld.func_217376_c((Entity)new ExperienceOrbEntity((World)serverWorld, this.mother.func_226277_ct_(), this.mother.func_226278_cu_(), this.mother.func_226281_cx_(), this.mother.func_70681_au().nextInt(2) + 1));
            }
        }
    }
}

