/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.goal;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.World;

public class CatMateGoal
extends Goal {
    private static final EntityPredicate PARTNER_TARGETING = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c();
    private static final double NEARBY_RADIUS_CHECK = 16.0;
    private final double moveSpeed;
    private final SimplyCatEntity cat;
    protected final World level;
    private SimplyCatEntity target;
    private int mateDelay;
    private List<SimplyCatEntity> nearbyCats;

    public CatMateGoal(SimplyCatEntity entityCat, double speed) {
        this.cat = entityCat;
        this.level = entityCat.field_70170_p;
        this.moveSpeed = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.cat.getSex() == Genetics.Sex.FEMALE) {
            return false;
        }
        this.nearbyCats = this.level.func_217357_a(((Object)((Object)this.cat)).getClass(), this.cat.func_174813_aQ().func_186662_g(16.0));
        if (this.nearbyCats.size() >= (Integer)SCConfig.Common.breeding_limit.get()) {
            return false;
        }
        LivingEntity catOwner = this.cat.func_70902_q();
        if (this.ownerExceedsLimit(this.cat, catOwner) || this.ownerIsOffline(this.cat, catOwner) || this.cat.getMateTimer() > 0) {
            return false;
        }
        this.target = this.getNearbyMate();
        if (this.target != null && this.cat.func_70635_at().func_75522_a((Entity)this.target) && this.target.getBreedingStatus("inheat")) {
            if (!this.target.func_70909_n()) {
                return true;
            }
            LivingEntity targetOwner = this.target.func_70902_q();
            return !this.ownerExceedsLimit(this.target, targetOwner) && !this.ownerIsOffline(this.target, targetOwner);
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.cat.func_233685_eM_() || this.target.func_233685_eM_()) {
            return false;
        }
        boolean maleCooldownCheck = this.cat.getSex() == Genetics.Sex.MALE && this.cat.getMateTimer() == 0;
        boolean femaleHeatCheck = this.target.getSex() == Genetics.Sex.FEMALE && this.target.getBreedingStatus("inheat");
        this.nearbyCats = this.level.func_217357_a(((Object)((Object)this.cat)).getClass(), this.cat.func_174813_aQ().func_186662_g(16.0));
        return maleCooldownCheck && this.target.func_70089_S() && femaleHeatCheck && this.mateDelay < 60 && this.nearbyCats.size() < (Integer)SCConfig.Common.breeding_limit.get() && this.cat.func_70635_at().func_75522_a((Entity)this.target);
    }

    private boolean ownerExceedsLimit(SimplyCatEntity tamedCat, LivingEntity owner) {
        return tamedCat != null && tamedCat.func_70909_n() && (Integer)SCConfig.Common.tamed_limit.get() != 0 && owner != null && owner.getPersistentData().func_74762_e("CatCount") >= (Integer)SCConfig.Common.tamed_limit.get();
    }

    private boolean ownerIsOffline(SimplyCatEntity tamedCat, LivingEntity owner) {
        return tamedCat != null && tamedCat.func_70909_n() && owner == null;
    }

    public void func_75251_c() {
        this.target = null;
        this.mateDelay = 0;
        this.nearbyCats.clear();
    }

    public void func_75246_d() {
        this.cat.func_70671_ap().func_75651_a((Entity)this.target, 10.0f, (float)this.cat.func_70646_bf());
        this.target.func_70671_ap().func_75651_a((Entity)this.cat, 10.0f, (float)this.target.func_70646_bf());
        this.cat.func_70661_as().func_75497_a((Entity)this.target, this.moveSpeed);
        this.target.func_70661_as().func_75497_a((Entity)this.cat, this.moveSpeed);
        ++this.mateDelay;
        if (this.mateDelay >= 60 && this.cat.func_70068_e((Entity)this.target) < 4.0) {
            if (this.level.field_73012_v.nextInt(4) <= 2) {
                this.startPregnancy();
            }
            this.cat.setMateTimer((Integer)SCConfig.Common.male_cooldown.get());
        }
    }

    private SimplyCatEntity getNearbyMate() {
        List list = this.level.func_217374_a(((Object)((Object)this.cat)).getClass(), PARTNER_TARGETING, (LivingEntity)this.cat, this.cat.func_174813_aQ().func_186662_g(16.0));
        double d0 = Double.MAX_VALUE;
        SimplyCatEntity entityCat = null;
        if (this.cat.getSex() == Genetics.Sex.MALE) {
            for (SimplyCatEntity cat1 : list) {
                if (!this.cat.func_70878_b((AnimalEntity)cat1) || !(this.cat.func_70068_e((Entity)cat1) < d0)) continue;
                entityCat = cat1;
                d0 = this.cat.func_70068_e((Entity)cat1);
            }
        }
        return entityCat;
    }

    private void startPregnancy() {
        int litterSize = this.target.getKittens() <= 0 ? this.level.field_73012_v.nextInt(6) + 1 : this.level.field_73012_v.nextInt(6 - this.target.getKittens()) + 1;
        this.target.setBreedingStatus("ispregnant", true);
        this.target.setKittens(litterSize);
        this.target.addFather(this.cat, this.target.getKittens());
        if (litterSize == 6 || this.target.getKittens() == 6 || this.level.field_73012_v.nextInt(4) == 0) {
            this.target.setBreedingStatus("inheat", false);
            this.target.setTimeCycle("pregnancy", (Integer)SCConfig.Common.pregnancy_timer.get());
        }
    }
}

