/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.item;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.github.mnesikos.simplycats.item.SCItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PetCarrierItem
extends Item {
    public PetCarrierItem() {
        super(new Item.Properties().func_200916_a(SimplyCats.ITEM_GROUP).func_200917_a(1));
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if ((target instanceof SimplyCatEntity || target instanceof WolfEntity || target instanceof ParrotEntity) && ((TameableEntity)target).func_70902_q() == player) {
            if (stack.func_77942_o()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.pet_carrier.full"), true);
                return ActionResultType.PASS;
            }
            target.revive();
            if (player.field_70170_p.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            CompoundNBT tags = new CompoundNBT();
            target.func_70039_c(tags);
            ResourceLocation key = EntityType.func_200718_a((EntityType)target.func_200600_R());
            tags.func_74778_a("id", key.toString());
            if (!(target instanceof SimplyCatEntity)) {
                tags.func_74778_a("OwnerName", player.func_200200_C_().getString());
            }
            if (target.func_145818_k_()) {
                tags.func_74778_a("DisplayName", target.func_145748_c_().getString());
            }
            target.func_70106_y();
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.pet_carrier.retrieve_pet"), true);
            ItemStack newStack = new ItemStack((IItemProvider)this);
            newStack.func_77982_d(tags);
            if (target instanceof SimplyCatEntity) {
                newStack.func_196085_b(1);
            } else {
                newStack.func_196085_b(2);
            }
            stack.func_190918_g(1);
            player.func_184611_a(hand, newStack);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        ItemStack item = context.func_195996_i();
        if (!item.func_77942_o() || item.func_77952_i() == 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.pet_carrier.empty"), true);
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            BlockPos blockPos = new BlockPos((Vector3i)context.func_195995_a()).func_177972_a(context.func_196000_l());
            if (item.func_77952_i() >= 3 && item.func_77952_i() <= 6) {
                this.newPet(item, player, world, blockPos);
                if (!player.func_184812_l_()) {
                    item.func_190918_g(1);
                }
            } else {
                Entity entity;
                CompoundNBT tags = item.func_77978_p();
                if ((item.func_77952_i() == 1 || item.func_77952_i() == 2) && (entity = EntityType.func_220335_a((CompoundNBT)tags, (World)world, entity1 -> entity1)) != null && entity instanceof TameableEntity) {
                    entity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, context.func_195990_h(), 0.0f);
                    ((TameableEntity)entity).func_233687_w_(true);
                    entity.func_184221_a(tags.func_186857_a("UUID"));
                    world.func_217376_c(entity);
                    item.func_190918_g(1);
                    player.func_184611_a(context.func_221531_n(), new ItemStack((IItemProvider)this));
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.pet_carrier.release_pet"), true);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void newPet(ItemStack item, PlayerEntity player, World world, BlockPos blockPos) {
        RabbitEntity rabbit;
        SimplyCatEntity pet = null;
        if (item.func_77952_i() == 3) {
            pet = (SimplyCatEntity)((EntityType)SimplyCats.CAT.get()).func_220331_a((ServerWorld)world, null, player, blockPos, SpawnReason.SPAWN_EGG, false, false);
        } else if (item.func_77952_i() == 4) {
            pet = (WolfEntity)EntityType.field_200724_aC.func_220331_a((ServerWorld)world, null, player, blockPos, SpawnReason.SPAWN_EGG, false, false);
        } else if (item.func_77952_i() == 5) {
            pet = (ParrotEntity)EntityType.field_200783_W.func_220331_a((ServerWorld)world, null, player, blockPos, SpawnReason.SPAWN_EGG, false, false);
        }
        if (pet instanceof SimplyCatEntity && !((SimplyCatEntity)pet).canBeTamed(player)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.tamed_limit_reached"), true);
        } else if (pet != null) {
            pet.func_233687_w_(true);
            if (pet instanceof SimplyCatEntity) {
                pet.setTamed(true, player);
            } else {
                pet.func_193101_c(player);
            }
            if (pet instanceof SimplyCatEntity) {
                pet.setHomePos(blockPos);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.set_home", new Object[]{pet.func_200200_C_(), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()}), true);
            }
            pet.func_70661_as().func_75499_g();
            float health = pet.func_110138_aP();
            pet.func_70606_j(health);
        } else if (item.func_77952_i() == 6 && (rabbit = (RabbitEntity)EntityType.field_200736_ab.func_220331_a((ServerWorld)world, null, player, blockPos, SpawnReason.SPAWN_EGG, false, false)) != null) {
            rabbit.func_70661_as().func_75499_g();
            rabbit.func_70606_j(rabbit.func_110138_aP());
        }
    }

    public ITextComponent func_200295_i(ItemStack item) {
        String unlocalizedName = super.func_200295_i(item).getString();
        unlocalizedName = !item.func_77942_o() || item.func_77952_i() == 0 ? unlocalizedName + "_empty" : unlocalizedName + "_full";
        return new TranslationTextComponent(unlocalizedName);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> itemList) {
        if (tab == this.func_77640_w()) {
            ItemStack cat = new ItemStack((IItemProvider)SCItems.PET_CARRIER.get(), 1, new CompoundNBT());
            cat.func_196085_b(3);
            itemList.add((Object)cat);
            itemList.add((Object)new ItemStack((IItemProvider)SCItems.PET_CARRIER.get(), 1));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack item, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = item.func_77978_p();
        if (nbt != null) {
            if (item.func_77952_i() == 3) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pet_carrier.adopt_cat").func_240699_a_(TextFormatting.ITALIC));
            } else if (item.func_77952_i() == 4) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pet_carrier.adopt_dog").func_240699_a_(TextFormatting.ITALIC));
            } else if (item.func_77952_i() == 5) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pet_carrier.adopt_parrot").func_240699_a_(TextFormatting.ITALIC));
            } else if (item.func_77952_i() == 6) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pet_carrier.adopt_rabbit").func_240699_a_(TextFormatting.ITALIC));
            } else if (item.func_77952_i() != 0) {
                TranslationTextComponent species = new TranslationTextComponent(Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation(nbt.func_74779_i("id"))));
                TranslationTextComponent owner = new TranslationTextComponent("tooltip.pet_carrier.owner", new Object[]{nbt.func_74779_i("OwnerName")});
                if (nbt.func_74764_b("DisplayName")) {
                    tooltip.add((ITextComponent)new StringTextComponent("\"" + nbt.func_74779_i("DisplayName") + "\"").func_240699_a_(TextFormatting.AQUA));
                } else {
                    tooltip.add((ITextComponent)species.func_240699_a_(TextFormatting.AQUA));
                }
                if (item.func_77952_i() == 1) {
                    tooltip.add((ITextComponent)Genetics.getPhenotypeDescription(nbt, true).func_240699_a_(TextFormatting.ITALIC));
                }
                tooltip.add((ITextComponent)owner);
            }
        } else {
            TranslationTextComponent empty = new TranslationTextComponent("tooltip.pet_carrier.empty");
            tooltip.add((ITextComponent)empty.func_240699_a_(TextFormatting.AQUA));
        }
    }
}

