/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.worldgen.villages;

import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simplycats")
public class SCWorldGen {
    private static final ResourceLocation desertShelterStructure = new ResourceLocation("simplycats", "village/desert_shelter_1");
    private static final ResourceLocation plainsShelterStructure = new ResourceLocation("simplycats", "village/plains_shelter_1");
    private static final ResourceLocation savannaShelterStructure = new ResourceLocation("simplycats", "village/savanna_shelter_1");
    private static final ResourceLocation snowyShelterStructure = new ResourceLocation("simplycats", "village/snowy_shelter_1");
    private static final ResourceLocation taigaShelterStructure = new ResourceLocation("simplycats", "village/taiga_shelter_1");

    public static void setupVillageWorldGen(DynamicRegistries dynamicRegistries) {
        SCWorldGen.addStructureToVillage(dynamicRegistries, "village/desert/houses", desertShelterStructure, 6);
        SCWorldGen.addStructureToVillage(dynamicRegistries, "village/plains/houses", plainsShelterStructure, 6);
        SCWorldGen.addStructureToVillage(dynamicRegistries, "village/savanna/houses", savannaShelterStructure, 6);
        SCWorldGen.addStructureToVillage(dynamicRegistries, "village/snowy/houses", snowyShelterStructure, 6);
        SCWorldGen.addStructureToVillage(dynamicRegistries, "village/taiga/houses", taigaShelterStructure, 6);
    }

    private static void addStructureToVillage(DynamicRegistries dynamicRegistries, String villagePool, ResourceLocation structureLocation, int weight) {
        LegacySingleJigsawPiece piece = (LegacySingleJigsawPiece)JigsawPiece.func_242849_a((String)structureLocation.toString()).apply(JigsawPattern.PlacementBehaviour.RIGID);
        JigsawPattern pool = dynamicRegistries.func_243612_b(Registry.field_243555_ax).func_241873_b(new ResourceLocation(villagePool)).orElse(null);
        if (pool != null) {
            ArrayList<LegacySingleJigsawPiece> piecesList = new ArrayList<LegacySingleJigsawPiece>(pool.field_214953_e);
            for (int i = 0; i < weight; ++i) {
                piecesList.add(piece);
            }
            pool.field_214953_e = piecesList;
        }
    }
}

