/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.DogEntity;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class DogWanderGoal
extends Goal {
    protected final DogEntity dog;
    protected final double speed;
    protected int executionChance;

    public DogWanderGoal(DogEntity dogIn, double speedIn) {
        this.dog = dogIn;
        this.speed = speedIn;
        this.executionChance = 60;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.dog.func_70909_n() || this.dog.func_184207_aI()) {
            return false;
        }
        if (!this.dog.isMode(EnumMode.WANDERING)) {
            return false;
        }
        Optional<BlockPos> bowlPos = this.dog.getBowlPos();
        if (!bowlPos.isPresent()) {
            return false;
        }
        return bowlPos.get().func_177951_i((Vector3i)this.dog.func_233580_cy_()) < 400.0;
    }

    public void func_75246_d() {
        if (this.dog.func_70654_ax() >= 100) {
            return;
        }
        if (this.dog.func_70681_au().nextInt(this.executionChance) != 0) {
            return;
        }
        if (this.dog.func_70781_l()) {
            return;
        }
        Vector3d pos = this.getPosition();
        this.dog.func_70661_as().func_75492_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.speed);
    }

    @Nullable
    protected Vector3d getPosition() {
        PathNavigator pathNavigate = this.dog.func_70661_as();
        Random random = this.dog.func_70681_au();
        int xzRange = 5;
        int yRange = 3;
        float bestWeight = Float.MIN_VALUE;
        Optional<BlockPos> bowlPos = this.dog.getBowlPos();
        BlockPos bestPos = bowlPos.get();
        for (int attempt = 0; attempt < 5; ++attempt) {
            float weight;
            int l = random.nextInt(2 * xzRange + 1) - xzRange;
            int i1 = random.nextInt(2 * yRange + 1) - yRange;
            int j1 = random.nextInt(2 * xzRange + 1) - xzRange;
            BlockPos testPos = bowlPos.get().func_177982_a(l, i1, j1);
            if (!pathNavigate.func_188555_b(testPos) || !((weight = this.dog.func_180484_a(testPos)) > bestWeight)) continue;
            bestWeight = weight;
            bestPos = testPos;
        }
        return new Vector3d((double)bestPos.func_177958_n(), (double)bestPos.func_177956_o(), (double)bestPos.func_177952_p());
    }
}

