/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogInventoryPageData;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class DogInventoryPagePacket
implements IPacket<DogInventoryPageData> {
    @Override
    public DogInventoryPageData decode(PacketBuffer buf) {
        return new DogInventoryPageData(buf.readInt());
    }

    @Override
    public void encode(DogInventoryPageData data, PacketBuffer buf) {
        buf.writeInt(data.page);
    }

    @Override
    public void handle(DogInventoryPageData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.SERVER) {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Container container = player.field_71070_bA;
                if (container instanceof DogInventoriesContainer) {
                    DogInventoriesContainer inventories = (DogInventoriesContainer)container;
                    int page = MathHelper.func_76125_a((int)data.page, (int)0, (int)Math.max(0, inventories.getTotalNumColumns() - 9));
                    inventories.setPage(page);
                    inventories.func_75137_b(0, page);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

