/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents2;
import doggytalents.common.entity.texture.DogTextureServer;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.RequestSkinData;
import doggytalents.common.network.packet.data.SendSkinData;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class RequestSkinPacket
implements IPacket<RequestSkinData> {
    @Override
    public void encode(RequestSkinData data, PacketBuffer buf) {
        buf.func_211400_a(data.hash, 128);
    }

    @Override
    public RequestSkinData decode(PacketBuffer buf) {
        return new RequestSkinData(buf.func_150789_c(128));
    }

    @Override
    public void handle(RequestSkinData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
            if (side.isServer()) {
                byte[] stream = DogTextureServer.INSTANCE.getCachedBytes(DogTextureServer.INSTANCE.getServerFolder(), data.hash);
                if (stream != null) {
                    DoggyTalents2.HANDLER.reply((Object)new SendSkinData(0, stream), (NetworkEvent.Context)ctx.get());
                    DoggyTalents2.LOGGER.debug("Client requested skin for hash  {}", (Object)data.hash);
                } else {
                    DoggyTalents2.LOGGER.warn("Client requested skin but no cache was available {}", (Object)data.hash);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

