/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyAttributes;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WolfMountTalent
extends TalentInstance {
    private static final UUID WOLF_MOUNT_JUMP = UUID.fromString("7f338124-f223-4630-8515-70ee0bfbc653");

    public WolfMountTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
        dogIn.setAttributeModifier((Attribute)DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void set(AbstractDogEntity dogIn, int level) {
        dogIn.setAttributeModifier((Attribute)DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    public AttributeModifier createSpeedModifier(AbstractDogEntity dogIn, UUID uuidIn) {
        if (this.level() > 0) {
            double speed = 0.06 * (double)this.level();
            if (this.level() >= 5) {
                speed += 0.04;
            }
            return new AttributeModifier(uuidIn, "Wolf Mount", speed, AttributeModifier.Operation.ADDITION);
        }
        return null;
    }

    @Override
    public ActionResultType processInteract(AbstractDogEntity dogIn, World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_190926_b() && dogIn.canInteract((LivingEntity)playerIn) && this.level() > 0 && playerIn.func_184187_bx() == null && !playerIn.func_233570_aj_()) {
            if (!dogIn.field_70170_p.field_72995_K) {
                dogIn.func_233687_w_(false);
                playerIn.field_70177_z = dogIn.field_70177_z;
                playerIn.field_70125_A = dogIn.field_70125_A;
                playerIn.func_184220_m((Entity)dogIn);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void livingTick(AbstractDogEntity dog) {
        if (dog.func_184207_aI() && dog.getDogHunger() < 1.0f) {
            dog.func_184179_bs().func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.wolf_mount.exhausted", new Object[]{dog.func_200200_C_()}), dog.func_110124_au());
            dog.func_184226_ay();
        }
    }

    @Override
    public ActionResult<Integer> hungerTick(AbstractDogEntity dogIn, int hungerTick) {
        if (dogIn.func_184186_bw()) {
            return ActionResult.func_226248_a_((Object)(hungerTick += this.level() < 5 ? 3 : 1));
        }
        return ActionResult.func_226250_c_((Object)hungerTick);
    }

    @Override
    public ActionResult<Float> calculateFallDistance(AbstractDogEntity dogIn, float distance) {
        if (this.level() >= 5) {
            return ActionResult.func_226248_a_((Object)Float.valueOf(distance - 1.0f));
        }
        return ActionResult.func_226250_c_((Object)Float.valueOf(0.0f));
    }

    @Override
    public ActionResultType hitByEntity(AbstractDogEntity dogIn, Entity entity) {
        return dogIn.func_184223_x(entity) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }
}

