/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import corgiaoc.byg.client.textures.renders.BYGCutoutRenders;
import corgiaoc.byg.common.entity.villager.BYGVillagerType;
import corgiaoc.byg.common.properties.BYGCreativeTab;
import corgiaoc.byg.common.properties.blocks.vanilla.ITreeSpawner;
import corgiaoc.byg.common.properties.vanilla.BYGCarvableBlocks;
import corgiaoc.byg.common.properties.vanilla.BYGCompostables;
import corgiaoc.byg.common.properties.vanilla.BYGFlammables;
import corgiaoc.byg.common.properties.vanilla.BYGHoeables;
import corgiaoc.byg.common.properties.vanilla.BYGPaths;
import corgiaoc.byg.common.properties.vanilla.BYGStrippables;
import corgiaoc.byg.common.world.biome.BYGBiome;
import corgiaoc.byg.common.world.biome.BYGEndBiome;
import corgiaoc.byg.common.world.biome.BYGEndSubBiome;
import corgiaoc.byg.common.world.biome.BYGNetherBiome;
import corgiaoc.byg.common.world.biome.BYGSubBiome;
import corgiaoc.byg.common.world.dimension.end.BYGEndBiomeSource;
import corgiaoc.byg.common.world.dimension.nether.BYGNetherBiomeSource;
import corgiaoc.byg.common.world.feature.overworld.trees.util.TreeSpawner;
import corgiaoc.byg.config.WorldConfig;
import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.entrypoint.EntryPoint;
import corgiaoc.byg.mixin.access.BlockEntityTypeAccess;
import corgiaoc.byg.mixin.access.ItemBlockRenderTypeAccess;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4131;
import net.minecraft.class_5458;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BYG {
    public static final String MOD_ID = "byg";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean isClient = false;
    public static boolean isUsingMixin;
    public static String FILE_PATH;
    public static Path CONFIG_PATH;
    public static EntryPoint entryPoint;
    public static WorldConfig worldConfig;
    public static final class_2960 EMPTY;
    public static class_2378<class_1959> biomeRegistryAccess;
    public static boolean ENABLE_OVERWORLD_TREES;
    public static boolean ENABLE_CACTI;
    public static boolean ENABLE_NYLIUM_FUNGI;
    public static boolean ENABLE_NETHER_MUSHROOMS;

    public static WorldConfig worldConfig(boolean refreshConfig) {
        if (worldConfig == null || refreshConfig) {
            worldConfig = new WorldConfig(CONFIG_PATH.resolve("byg-world.toml"));
        }
        return worldConfig;
    }

    public static WorldConfig worldConfig() {
        return BYG.worldConfig(false);
    }

    public BYG() {
        File dir = new File(CONFIG_PATH.toString());
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public static void commonLoad() {
        LOGGER.debug("BYG: \"Common Setup\" Event Starting...");
        BYGCreativeTab.init();
        for (class_2248 block : class_2378.field_11146) {
            if (!(block instanceof ITreeSpawner) || !ITreeSpawner.VANILLA_SAPLING_BYG_TREE_SPAWNERS.containsKey((Object)block)) continue;
            ((ITreeSpawner)block).setTreeSpawner((TreeSpawner)ITreeSpawner.VANILLA_SAPLING_BYG_TREE_SPAWNERS.get((Object)block));
        }
        LOGGER.info("BYG: \"Common Setup\" Event Complete!");
    }

    public static void threadSafeCommonLoad() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960(MOD_ID, "byg_nether"), BYGNetherBiomeSource.BYGNETHERCODEC);
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960(MOD_ID, "byg_end"), BYGEndBiomeSource.BYGENDCODEC);
        BYGVillagerType.setVillagerForBYGBiomes();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        BYG.handleOverWorldConfig(gson);
        BYG.handleOverWorldSubConfig(gson);
        BlockEntityTypeAccess builderAccess = (BlockEntityTypeAccess)class_2591.field_17380;
        ObjectOpenHashSet validBlocks = new ObjectOpenHashSet(builderAccess.getValidBlocks());
        validBlocks.add(BYGBlocks.CRYPTIC_CAMPFIRE);
        validBlocks.add(BYGBlocks.BORIC_CAMPFIRE);
        builderAccess.setValidBlocks((Set<class_2248>)validBlocks);
    }

    public static BiomeDataHolders.EndBiomeDataHolder getEndData(Gson gson, Path biomesConfigPath) {
        BiomeDataHolders.EndBiomeDataHolder endBiomeDataHolder = BYGEndBiome.extractDefaultHolder((class_2378<class_1959>)class_5458.field_25933);
        File biomesConfigFile = biomesConfigPath.toFile();
        try {
            Optional result;
            if (!biomesConfigFile.exists()) {
                DataResult jsonElementDataResult = BiomeDataHolders.EndBiomeDataHolder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)endBiomeDataHolder);
                Files.createDirectories(biomesConfigPath.getParent(), new FileAttribute[0]);
                Files.write(biomesConfigPath, gson.toJson((JsonElement)jsonElementDataResult.result().get()).getBytes(), new OpenOption[0]);
            }
            if ((result = BiomeDataHolders.EndBiomeDataHolder.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(biomesConfigFile))).result()).isPresent()) {
                endBiomeDataHolder = (BiomeDataHolders.EndBiomeDataHolder)((Pair)result.get()).getFirst();
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read \"" + biomesConfigPath.toString() + "\"... using internal defaults...");
            e.printStackTrace();
        }
        BYGBiomes.fillBiomeDictionary(endBiomeDataHolder.getEndBiomeData());
        BYGBiomes.fillBiomeDictionary(endBiomeDataHolder.getVoidBiomeData());
        return endBiomeDataHolder;
    }

    public static BiomeDataHolders.WeightedBiomeDataHolder getNetherData(Gson gson, Path biomesConfigPath) {
        BiomeDataHolders.WeightedBiomeDataHolder endWeightedBiomeDataHolder = BYGNetherBiome.extractDefaultHolder((class_2378<class_1959>)class_5458.field_25933);
        File biomesConfigFile = biomesConfigPath.toFile();
        try {
            Optional result;
            if (!biomesConfigFile.exists()) {
                DataResult jsonElementDataResult = BiomeDataHolders.WeightedBiomeDataHolder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)endWeightedBiomeDataHolder);
                Files.createDirectories(biomesConfigPath.getParent(), new FileAttribute[0]);
                Files.write(biomesConfigPath, gson.toJson((JsonElement)jsonElementDataResult.result().get()).getBytes(), new OpenOption[0]);
            }
            if ((result = BiomeDataHolders.WeightedBiomeDataHolder.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(biomesConfigFile))).result()).isPresent()) {
                endWeightedBiomeDataHolder = (BiomeDataHolders.WeightedBiomeDataHolder)((Pair)result.get()).getFirst();
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read \"" + biomesConfigPath.toString() + "\"... using internal defaults...");
            e.printStackTrace();
        }
        BYGBiomes.fillBiomeDictionary(endWeightedBiomeDataHolder.getBiomeData());
        return endWeightedBiomeDataHolder;
    }

    public static BiomeDataHolders.EndSubBiomeDataHolder getEndSubBiomeData(Gson gson, Path biomesConfigPath) {
        BiomeDataHolders.EndSubBiomeDataHolder endBiomeDataHolder = BYGEndSubBiome.extractDefaultHolder((class_2378<class_1959>)class_5458.field_25933);
        File biomesConfigFile = biomesConfigPath.toFile();
        try {
            Optional result;
            if (!biomesConfigFile.exists()) {
                DataResult jsonElementDataResult = BiomeDataHolders.EndSubBiomeDataHolder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)endBiomeDataHolder);
                Files.createDirectories(biomesConfigPath.getParent(), new FileAttribute[0]);
                Files.write(biomesConfigPath, gson.toJson((JsonElement)jsonElementDataResult.result().get()).getBytes(), new OpenOption[0]);
            }
            if ((result = BiomeDataHolders.EndSubBiomeDataHolder.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(biomesConfigFile))).result()).isPresent()) {
                endBiomeDataHolder = (BiomeDataHolders.EndSubBiomeDataHolder)((Pair)result.get()).getFirst();
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read \"" + biomesConfigPath.toString() + "\"... using internal defaults...");
            e.printStackTrace();
        }
        BYGBiomes.fillBiomeDictionary(endBiomeDataHolder.getEndSubBiomeData());
        BYGBiomes.fillBiomeDictionary(endBiomeDataHolder.getVoidSubBiomeData());
        return endBiomeDataHolder;
    }

    private static void handleOverWorldConfig(Gson gson) {
        BiomeDataHolders.OverworldPrimaryBiomeDataHolder overworldPrimaryBiomeDataHolder = BYGBiome.extractDefaultHolder();
        Path biomesConfigPath = CONFIG_PATH.resolve("byg-biomes.json");
        File biomesConfigFile = biomesConfigPath.toFile();
        try {
            Optional result;
            if (!biomesConfigFile.exists()) {
                DataResult jsonElementDataResult = BiomeDataHolders.OverworldPrimaryBiomeDataHolder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)overworldPrimaryBiomeDataHolder);
                Files.createDirectories(biomesConfigPath.getParent(), new FileAttribute[0]);
                Files.write(biomesConfigPath, gson.toJson((JsonElement)jsonElementDataResult.result().get()).getBytes(), new OpenOption[0]);
            }
            if ((result = BiomeDataHolders.OverworldPrimaryBiomeDataHolder.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(biomesConfigFile))).result()).isPresent()) {
                overworldPrimaryBiomeDataHolder = (BiomeDataHolders.OverworldPrimaryBiomeDataHolder)((Pair)result.get()).getFirst();
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read \"" + biomesConfigPath.toString() + "\"... using internal defaults...");
            e.printStackTrace();
        }
        overworldPrimaryBiomeDataHolder.getBiomeData().forEach((location, primaryBiomeData) -> {
            class_2960 edgeBiome;
            class_2960 beach;
            class_2960 river = primaryBiomeData.getRiver();
            if (!river.equals((Object)EMPTY)) {
                BYGBiome.BIOME_TO_RIVER_LIST.put((class_2960)location, river);
            }
            if (!(beach = primaryBiomeData.getBeach()).equals((Object)EMPTY)) {
                BYGBiome.BIOME_TO_BEACH_LIST.put((class_2960)location, beach);
            }
            if (!(edgeBiome = primaryBiomeData.getEdgeBiome()).equals((Object)EMPTY)) {
                BYGBiome.BIOME_TO_EDGE_LIST.put((class_2960)location, edgeBiome);
            }
            class_4131<class_2960> subBiomes = primaryBiomeData.getSubBiomes();
            BYGBiome.BIOME_TO_HILLS_LIST.put((class_2960)location, subBiomes);
        });
        BYGBiomes.handleOverworldEntries(overworldPrimaryBiomeDataHolder);
    }

    private static void handleOverWorldSubConfig(Gson gson) {
        BiomeDataHolders.OverworldSubBiomeDataHolder overworldSubBiomeDataHolder = BYGSubBiome.extractDefaultHolder();
        Path biomesConfigPath = CONFIG_PATH.resolve("byg-sub-biomes.json");
        File biomesConfigFile = biomesConfigPath.toFile();
        try {
            Optional result;
            if (!biomesConfigFile.exists()) {
                DataResult jsonElementDataResult = BiomeDataHolders.OverworldSubBiomeDataHolder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)overworldSubBiomeDataHolder);
                Files.createDirectories(biomesConfigPath.getParent(), new FileAttribute[0]);
                Files.write(biomesConfigPath, gson.toJson((JsonElement)jsonElementDataResult.result().get()).getBytes(), new OpenOption[0]);
            }
            if ((result = BiomeDataHolders.OverworldSubBiomeDataHolder.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(biomesConfigFile))).result()).isPresent()) {
                overworldSubBiomeDataHolder = (BiomeDataHolders.OverworldSubBiomeDataHolder)((Pair)result.get()).getFirst();
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read \"" + biomesConfigPath.toString() + "\"... using internal defaults...");
            e.printStackTrace();
        }
        overworldSubBiomeDataHolder.getBiomeData().forEach((location, subBiomeData) -> {
            class_2960 edgeBiome;
            class_2960 beach;
            class_2960 river = subBiomeData.getRiver();
            if (!river.equals((Object)EMPTY)) {
                BYGBiome.BIOME_TO_RIVER_LIST.put((class_2960)location, river);
            }
            if (!(beach = subBiomeData.getBeach()).equals((Object)EMPTY)) {
                BYGBiome.BIOME_TO_BEACH_LIST.put((class_2960)location, beach);
            }
            if (!(edgeBiome = subBiomeData.getEdgeBiome()).equals((Object)EMPTY)) {
                BYGBiome.BIOME_TO_EDGE_LIST.put((class_2960)location, edgeBiome);
            }
        });
        BYGBiomes.fillBiomeDictionary(overworldSubBiomeDataHolder.getBiomeData());
    }

    public static void clientLoad() {
        isClient = true;
        LOGGER.debug("BYG: \"Client Setup\" Event Starting...");
        BYGCutoutRenders.renderCutOuts(ItemBlockRenderTypeAccess.getTypeByBlock());
        LOGGER.info("BYG: \"Client Setup\" Event Complete!");
    }

    public static void threadSafeLoadFinish() {
        LOGGER.debug("BYG: \"Load Complete Event\" Starting...");
        BYGCompostables.compostablesBYG();
        BYGHoeables.hoeablesBYG();
        BYGFlammables.flammablesBYG();
        BYGStrippables.strippableLogsBYG();
        BYGCarvableBlocks.addCarverBlocks();
        BYGPaths.addBYGPaths();
        LOGGER.info("BYG: \"Load Complete\" Event Complete!");
    }

    static {
        FILE_PATH = "yeet";
        CONFIG_PATH = null;
        entryPoint = null;
        worldConfig = null;
        EMPTY = new class_2960("");
        biomeRegistryAccess = null;
        ENABLE_OVERWORLD_TREES = true;
        ENABLE_CACTI = true;
        ENABLE_NYLIUM_FUNGI = true;
        ENABLE_NETHER_MUSHROOMS = true;
    }
}

