/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.biome;

import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.config.json.biomedata.WeightedBiomeData;
import corgiaoc.byg.mixin.access.BiomeAccess;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import corgiaoc.byg.mixin.access.WeightedListEntryAccess;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4131;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_5485;

public class BYGNetherBiome {
    public static final List<BYGNetherBiome> BYG_NETHER_BIOMES = new ArrayList<BYGNetherBiome>();
    private final class_1959 biome;

    public BYGNetherBiome(class_1959.class_5482 climate, class_1959.class_1961 category, float depth, float scale, class_4763 effects, class_5485 biomeGenerationSettings, class_5483 mobSpawnInfo) {
        this.biome = BiomeAccess.create(climate, category, depth, scale, effects, biomeGenerationSettings, mobSpawnInfo);
        BYG_NETHER_BIOMES.add(this);
    }

    public BYGNetherBiome(class_1959.class_1960 builder) {
        this.biome = builder.method_30972();
        BYG_NETHER_BIOMES.add(this);
    }

    public BYGNetherBiome(class_1959 biome) {
        this.biome = biome;
        BYG_NETHER_BIOMES.add(this);
    }

    public class_1959 getBiome() {
        return this.biome;
    }

    public class_4131<class_1959> getHills() {
        return new class_4131();
    }

    @Nullable
    public class_1959 getEdge() {
        return null;
    }

    public int getWeight() {
        return 5;
    }

    public String[] getBiomeDictionary() {
        return new String[]{"NETHER"};
    }

    public class_5321<class_1959> getKey() {
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)Objects.requireNonNull(class_5458.field_25933.method_10221((Object)this.biome)));
    }

    public static BiomeDataHolders.WeightedBiomeDataHolder extractDefaultHolder(class_2378<class_1959> biomeRegistry) {
        HashMap<class_2960, WeightedBiomeData> biomeData = new HashMap<class_2960, WeightedBiomeData>();
        for (BYGNetherBiome bygBiome : BYG_NETHER_BIOMES) {
            List<String> dictionary = Arrays.asList(bygBiome.getBiomeDictionary());
            class_4131 weightedListByLocation = new class_4131();
            for (class_4131.class_4132 entry : ((WeightedListAccess)bygBiome.getHills()).getEntries()) {
                weightedListByLocation.method_19031(entry.method_19035(), ((WeightedListEntryAccess)entry).getWeight());
            }
            WeightedBiomeData weightedBiomeData = new WeightedBiomeData(bygBiome.getWeight(), dictionary, bygBiome.getEdge() != null ? biomeRegistry.method_10221((Object)bygBiome.getEdge()) : new class_2960(""), (class_4131<class_2960>)weightedListByLocation);
            class_2960 key = biomeRegistry.method_10221((Object)bygBiome.getBiome());
            if (key == null) continue;
            biomeData.put(key, weightedBiomeData);
        }
        for (class_1959 biome : biomeRegistry) {
            class_2960 biomeKey = biomeRegistry.method_10221((Object)biome);
            if (biome.method_8688() != class_1959.class_1961.field_9366 || biomeData.containsKey(biomeKey)) continue;
            assert (biomeKey != null);
            biomeData.put(biomeKey, new WeightedBiomeData(5, Collections.singletonList("NETHER"), new class_2960(""), (class_4131<class_2960>)new class_4131()));
        }
        return new BiomeDataHolders.WeightedBiomeDataHolder((Map<class_2960, WeightedBiomeData>)biomeData);
    }
}

