/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.end;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.end.SimpleLayerProvider;
import corgiaoc.byg.config.json.biomedata.BiomeData;
import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.config.json.biomedata.WeightedBiomeData;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3541;
import net.minecraft.class_4131;
import net.minecraft.class_5321;
import net.minecraft.class_5505;

public class BYGEndBiomeSource
extends class_1966 {
    public static final Codec<BYGEndBiomeSource> BYGENDCODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGEndBiomeSource::new)));
    private final long seed;
    private final DatapackLayer mainIslandLayer;
    private final DatapackLayer smallIslandLayer;
    private final class_2378<class_1959> biomeRegistry;
    private final class_3541 generator;

    public BYGEndBiomeSource(class_2378<class_1959> registry, long seed) {
        super(new ArrayList());
        this.seed = seed;
        class_2919 sharedseedrandom = new class_2919(seed);
        sharedseedrandom.method_12660(17292);
        this.biomeRegistry = registry;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        class_4131 endBiomes = new class_4131();
        HashMap<class_2960, class_4131<class_2960>> endHills = new HashMap<class_2960, class_4131<class_2960>>();
        HashMap<class_2960, class_2960> biomeToEdge = new HashMap<class_2960, class_2960>();
        HashSet allBiomes = new HashSet();
        BiomeDataHolders.EndBiomeDataHolder endBiomeDataHolder = BYG.getEndData(gson, BYG.CONFIG_PATH.resolve("byg-end-biomes.json"));
        Map<class_2960, WeightedBiomeData> endBiomeData1 = endBiomeDataHolder.getEndBiomeData();
        endBiomeData1.remove(null);
        endBiomeData1.remove(BYG.EMPTY);
        endBiomeData1.forEach((biome, endBiomeData) -> {
            endBiomes.method_19031(biome, endBiomeData.getWeight());
            endHills.put((class_2960)biome, endBiomeData.getSubBiomes());
            class_2960 edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                biomeToEdge.put((class_2960)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.addAll(((WeightedListAccess)endBiomeData.getSubBiomes()).getEntries().stream().map(class_4131.class_4132::method_19035).collect(Collectors.toList()));
        });
        endHills.remove(BYG.EMPTY);
        biomeToEdge.remove(BYG.EMPTY);
        endHills.remove(null);
        biomeToEdge.remove(null);
        class_4131 voidBiomes = new class_4131();
        HashMap<class_2960, class_4131<class_2960>> voidHillsMap = new HashMap<class_2960, class_4131<class_2960>>();
        HashMap<class_2960, class_2960> voidBiomeToEdge = new HashMap<class_2960, class_2960>();
        Map<class_2960, WeightedBiomeData> voidBiomeData = endBiomeDataHolder.getVoidBiomeData();
        voidBiomeData.remove(null);
        voidBiomeData.remove(BYG.EMPTY);
        voidBiomeData.forEach((biome, endBiomeData) -> {
            voidBiomes.method_19031(biome, endBiomeData.getWeight());
            voidHillsMap.put((class_2960)biome, endBiomeData.getSubBiomes());
            class_2960 edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                voidBiomeToEdge.put((class_2960)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.addAll(((WeightedListAccess)endBiomeData.getSubBiomes()).getEntries().stream().map(class_4131.class_4132::method_19035).collect(Collectors.toList()));
        });
        BiomeDataHolders.EndSubBiomeDataHolder endSubBiomeDataHolder = BYG.getEndSubBiomeData(gson, BYG.CONFIG_PATH.resolve("byg-end-sub-biomes.json"));
        Map<class_2960, BiomeData> endSubBiomeData = endSubBiomeDataHolder.getEndSubBiomeData();
        endSubBiomeData.remove(null);
        endSubBiomeData.remove(BYG.EMPTY);
        endSubBiomeData.forEach((biome, endBiomeData) -> {
            class_2960 edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                biomeToEdge.put((class_2960)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.add(endBiomeData.getEdgeBiome());
        });
        Map<class_2960, BiomeData> voidSubBiomeData = endSubBiomeDataHolder.getVoidSubBiomeData();
        voidSubBiomeData.remove(null);
        voidBiomeData.remove(BYG.EMPTY);
        voidSubBiomeData.forEach((biome, endBiomeData) -> {
            class_2960 edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                voidBiomeToEdge.put((class_2960)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.add(endBiomeData.getEdgeBiome());
        });
        voidHillsMap.remove(BYG.EMPTY);
        voidBiomeToEdge.remove(BYG.EMPTY);
        voidHillsMap.remove(null);
        voidBiomeToEdge.remove(null);
        this.field_20643.addAll(allBiomes.stream().filter(resourceLocation -> resourceLocation != null && !resourceLocation.equals((Object)BYG.EMPTY)).map(arg_0 -> registry.method_10223(arg_0)).collect(Collectors.toList()));
        this.mainIslandLayer = SimpleLayerProvider.stackLayers(this.biomeRegistry, seed, BYG.worldConfig().endBiomeSize, (class_4131<class_2960>)endBiomes, endHills, biomeToEdge);
        this.smallIslandLayer = SimpleLayerProvider.stackLayers(this.biomeRegistry, seed, BYG.worldConfig().voidBiomeSize, (class_4131<class_2960>)voidBiomes, voidHillsMap, voidBiomeToEdge);
        this.generator = new class_3541((Random)sharedseedrandom);
    }

    protected Codec<? extends class_1966> method_28442() {
        return BYGENDCODEC;
    }

    public class_1966 method_27985(long seed) {
        return new BYGEndBiomeSource(this.biomeRegistry, seed);
    }

    public class_1959 method_16359(int x, int y, int z) {
        int xBitOffset = x >> 2;
        int zBitOffset = z >> 2;
        if ((long)xBitOffset * (long)xBitOffset + (long)zBitOffset * (long)zBitOffset <= 4096L) {
            return (class_1959)this.biomeRegistry.method_31140(class_1972.field_9411);
        }
        float sampledNoise = class_2169.method_8757((class_3541)this.generator, (int)(xBitOffset * 2 + 1), (int)(zBitOffset * 2 + 1));
        if (sampledNoise >= -20.0f) {
            return this.mainIslandLayer.sampleEnd(this.biomeRegistry, x, z);
        }
        return this.smallIslandLayer.sampleEndVoid(this.biomeRegistry, x, z);
    }
}

