/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.nether;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.end.SimpleLayerProvider;
import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4131;
import net.minecraft.class_5321;
import net.minecraft.class_5505;

public class BYGNetherBiomeSource
extends class_1966 {
    public static final Codec<BYGNetherBiomeSource> BYGNETHERCODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGNetherBiomeSource::new)));
    private final DatapackLayer biomeLayer;
    private final long seed;
    private final class_2378<class_1959> biomeRegistry;
    public static List<class_2960> NETHER_BIOMES = new ArrayList<class_2960>();

    public BYGNetherBiomeSource(class_2378<class_1959> registry, long seed) {
        super(new ArrayList());
        this.seed = seed;
        this.biomeRegistry = registry;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        class_4131 biomes = new class_4131();
        HashMap<class_2960, class_4131<class_2960>> hills = new HashMap<class_2960, class_4131<class_2960>>();
        HashMap<class_2960, class_2960> edges = new HashMap<class_2960, class_2960>();
        HashSet allBiomes = new HashSet();
        BiomeDataHolders.WeightedBiomeDataHolder netherData = BYG.getNetherData(gson, BYG.CONFIG_PATH.resolve("byg-nether-biomes.json"));
        Map biomeData = netherData.getBiomeData();
        biomeData.remove(null);
        biomeData.remove(BYG.EMPTY);
        biomeData.forEach((biome, endBiomeData) -> {
            biomes.method_19031(biome, endBiomeData.getWeight());
            hills.put((class_2960)biome, endBiomeData.getSubBiomes());
            class_2960 edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                edges.put((class_2960)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.addAll(((WeightedListAccess)endBiomeData.getSubBiomes()).getEntries().stream().map(class_4131.class_4132::method_19035).collect(Collectors.toList()));
        });
        edges.remove(BYG.EMPTY);
        hills.remove(BYG.EMPTY);
        allBiomes.remove(BYG.EMPTY);
        edges.remove(null);
        hills.remove(null);
        allBiomes.remove(null);
        this.field_20643.addAll(allBiomes.stream().filter(resourceLocation -> resourceLocation != null && !resourceLocation.equals((Object)BYG.EMPTY)).map(arg_0 -> registry.method_10223(arg_0)).collect(Collectors.toList()));
        this.biomeLayer = SimpleLayerProvider.stackLayers(this.biomeRegistry, seed, BYG.worldConfig().netherBiomeSize, (class_4131<class_2960>)biomes, hills, edges);
    }

    protected Codec<? extends class_1966> method_28442() {
        return BYGNETHERCODEC;
    }

    public class_1966 method_27985(long seed) {
        return new BYGNetherBiomeSource(this.biomeRegistry, seed);
    }

    public class_1959 method_16359(int x, int y, int z) {
        return this.biomeLayer.sampleNether(this.biomeRegistry, x, z);
    }
}

