/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4970;

public class BYGTreeConfig
implements class_3037 {
    public static final Codec<BYGTreeConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("trunk_provider").orElse((Object)new class_4656(class_2246.field_10431.method_9564())).forGetter(config -> config.trunkProvider), (App)class_4651.field_24937.fieldOf("leaves_provider").orElse((Object)new class_4656(class_2246.field_10503.method_9564())).forGetter(config -> config.leavesProvider), (App)class_4651.field_24937.fieldOf("ground_replacement_provider").orElse((Object)new class_4656(class_2246.field_10566.method_9564())).forGetter(config -> config.groundReplacementProvider), (App)class_4651.field_24937.fieldOf("disk_provider").orElse((Object)new class_4656(class_2246.field_10520.method_9564())).forGetter(config -> config.diskProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)15).forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("disk_radius").orElse((Object)0).forGetter(config -> config.diskRadius), (App)class_2680.field_24734.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()))).apply((Applicative)codecRecorder, BYGTreeConfig::new));
    private final class_4651 trunkProvider;
    private final class_4651 leavesProvider;
    @Deprecated
    private final class_4651 groundReplacementProvider;
    private final class_4651 diskProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int diskRadius;
    private final Set<class_2248> whitelist;
    private boolean forcedPlacement = false;
    private class_2470 rotation = class_2470.field_11467;
    private class_2415 mirror = class_2415.field_11302;

    BYGTreeConfig(class_4651 trunkProvider, class_4651 leavesProvider, class_4651 groundReplacementProvider, class_4651 diskProvider, int minHeight, int maxHeight, int diskRadius, List<class_2680> whitelist) {
        this.trunkProvider = trunkProvider;
        this.leavesProvider = leavesProvider;
        this.groundReplacementProvider = groundReplacementProvider;
        this.diskProvider = diskProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.diskRadius = diskRadius;
        this.whitelist = whitelist.stream().map(class_4970.class_4971::method_26204).collect(Collectors.toSet());
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public class_4651 getTrunkProvider() {
        return this.trunkProvider;
    }

    public class_4651 getLeavesProvider() {
        return this.leavesProvider;
    }

    @Deprecated
    public class_4651 getGroundReplacementProvider() {
        return this.groundReplacementProvider;
    }

    public class_4651 getDiskProvider() {
        return this.diskProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getDiskRadius() {
        return this.diskRadius;
    }

    public Set<class_2248> getWhitelist() {
        return this.whitelist;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public void setRotationAndMirror(class_2470 rotation, class_2415 mirror) {
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    public static class Builder {
        private class_4651 trunkProvider = new class_4656(class_2246.field_10431.method_9564());
        private class_4651 leavesProvider = new class_4656(class_2246.field_10503.method_9564());
        @Deprecated
        private class_4651 groundReplacementProvider = new class_4656(class_2246.field_10566.method_9564());
        private class_4651 diskProvider = new class_4656(class_2246.field_10520.method_9564());
        private List<class_2248> whitelist = ImmutableList.of((Object)class_2246.field_10219);
        private int minHeight = 15;
        private int maxPossibleHeight = 1;
        private int diskRadius = 0;

        public Builder setTrunkBlock(class_2248 block) {
            this.trunkProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10431.method_9564());
            return this;
        }

        public Builder setTrunkBlock(class_2680 state) {
            this.trunkProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10431.method_9564());
            return this;
        }

        public Builder setTrunkBlock(class_4651 stateProvider) {
            this.trunkProvider = stateProvider != null ? stateProvider : new class_4656(class_2246.field_10431.method_9564());
            return this;
        }

        public Builder setLeavesBlock(class_2248 block) {
            this.leavesProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setLeavesBlock(class_2680 state) {
            this.leavesProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setLeavesBlock(class_4651 stateProvider) {
            this.leavesProvider = stateProvider != null ? stateProvider : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        @Deprecated
        public Builder setGroundReplacementBlock(class_2248 block) {
            this.groundReplacementProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10566.method_9564());
            return this;
        }

        @Deprecated
        public Builder setGroundReplacementBlock(class_2680 state) {
            this.groundReplacementProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10124.method_9564());
            return this;
        }

        @Deprecated
        public Builder setGroundReplacementBlock(class_4651 stateProvider) {
            this.groundReplacementProvider = stateProvider != null ? stateProvider : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setDiskBlock(class_2248 block) {
            this.diskProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10124.method_9564());
            return this;
        }

        public Builder setDiskBlock(class_2680 state) {
            this.diskProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10124.method_9564());
            return this;
        }

        public Builder setDiskBlock(class_4651 stateProvider) {
            this.diskProvider = stateProvider != null ? stateProvider : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setDiskRadius(int diskRadius) {
            this.diskRadius = Math.abs(diskRadius);
            return this;
        }

        public Builder setWhitelist(ImmutableList<class_2248> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(BYGTreeConfig config) {
            this.trunkProvider = config.trunkProvider;
            this.leavesProvider = config.leavesProvider;
            this.groundReplacementProvider = config.groundReplacementProvider;
            this.diskProvider = config.diskProvider;
            this.maxPossibleHeight = config.maxHeight;
            this.minHeight = config.minHeight;
            this.diskRadius = config.diskRadius;
            this.whitelist = ImmutableList.copyOf((Collection)config.whitelist);
            return this;
        }

        public BYGTreeConfig build() {
            return new BYGTreeConfig(this.trunkProvider, this.leavesProvider, this.groundReplacementProvider, this.diskProvider, this.minHeight, this.maxPossibleHeight, this.diskRadius, this.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()));
        }
    }
}

