/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;

public class BoulderConfig
implements class_3037 {
    public static final Codec<BoulderConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("min_stack_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_stack_height").orElse((Object)15).forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("min_radius").orElse((Object)11).forGetter(config -> config.minRadius), (App)Codec.INT.fieldOf("max_radius").orElse((Object)15).forGetter(config -> config.maxRadius), (App)Codec.DOUBLE.fieldOf("radius_divisor_per_stack").orElse((Object)1.1).forGetter(config -> config.radiusDivisorPerStack), (App)Codec.BOOL.fieldOf("flatten_top_boulder").orElse((Object)false).forGetter(config -> config.flattenTopBoulder)).apply((Applicative)codecRecorder, BoulderConfig::new));
    private final class_4651 blockProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int minRadius;
    private final int maxRadius;
    private final double radiusDivisorPerStack;
    private final boolean flattenTopBoulder;

    BoulderConfig(class_4651 blockProvider, int minHeight, int maxHeight, int minRadius, int maxRadius, double radiusDivisorPerStack, boolean flattenTopBoulder) {
        this.blockProvider = blockProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.radiusDivisorPerStack = radiusDivisorPerStack;
        this.flattenTopBoulder = flattenTopBoulder;
    }

    public class_4651 getBlockProvider() {
        return this.blockProvider;
    }

    public int getMinHeight() {
        return Math.abs(this.minHeight);
    }

    public int getMaxHeight() {
        return Math.abs(this.maxHeight);
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue + 1;
    }

    public int getMinRadius() {
        return Math.abs(this.minRadius);
    }

    public int getMaxRadius() {
        return Math.abs(this.maxRadius);
    }

    public int getMaxPossibleRadius() {
        int returnValue = this.maxRadius - this.minRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public double getRadiusDivisorPerStack() {
        return this.radiusDivisorPerStack;
    }

    public boolean isTopBoulderFlat() {
        return this.flattenTopBoulder;
    }

    public static class Builder {
        private class_4651 blockProvider = new class_4656(class_2246.field_10340.method_9564());
        private int minStackHeight = 1;
        private int maxStackHeight = 1;
        private int minRadius = 1;
        private int maxRadius = 3;
        private double radiusDivisorPerStack = 1.2;
        private boolean flattenTopBoulder = false;

        public Builder setBlock(class_2248 block) {
            this.blockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2680 state) {
            this.blockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_4651 provider) {
            this.blockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setMinStackHeight(int minStackHeight) {
            this.minStackHeight = minStackHeight <= 0 ? 1 : minStackHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxStackHeight = maxPossibleHeight <= 0 ? this.minStackHeight + 1 : maxPossibleHeight;
            return this;
        }

        public Builder setMinRadius(int minRadius) {
            this.minRadius = minRadius <= 0 ? 1 : minRadius;
            return this;
        }

        public Builder setMaxRadius(int maxRadius) {
            this.maxRadius = maxRadius <= 0 ? this.minRadius + 1 : maxRadius;
            return this;
        }

        public Builder setRadiusDivisor(double radiusDivisorPerStack) {
            this.radiusDivisorPerStack = radiusDivisorPerStack;
            return this;
        }

        public Builder flattenTopBoulder() {
            this.flattenTopBoulder = true;
            return this;
        }

        public Builder copy(BoulderConfig config) {
            this.blockProvider = config.blockProvider;
            this.minStackHeight = config.minHeight;
            this.maxStackHeight = config.maxHeight;
            this.minRadius = config.minRadius;
            this.maxRadius = config.maxRadius;
            this.radiusDivisorPerStack = config.radiusDivisorPerStack;
            return this;
        }

        public BoulderConfig build() {
            return new BoulderConfig(this.blockProvider, this.minStackHeight, this.maxStackHeight, this.minRadius, this.maxRadius, this.radiusDivisorPerStack, this.flattenTopBoulder);
        }
    }
}

