/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4970;

public class ChainConfig
implements class_3037 {
    public static final Codec<ChainConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("x_axis_block_provider").forGetter(config -> config.xAxisBlockProvider), (App)class_4651.field_24937.fieldOf("z_axis_block_provider").forGetter(config -> config.zAxisBlockProvider), (App)Codec.INT.fieldOf("min_length").forGetter(config -> config.minLength), (App)Codec.INT.fieldOf("max_length").forGetter(config -> config.maxLength), (App)class_2680.field_24734.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()))).apply((Applicative)codecRecorder, ChainConfig::new));
    private final class_4651 xAxisBlockProvider;
    private final class_4651 zAxisBlockProvider;
    private final int minLength;
    private final int maxLength;
    private final Set<class_2248> whitelist;

    ChainConfig(class_4651 baseBlockProvider, class_4651 blockProvider, int minLength, int maxLength, List<class_2680> whitelist) {
        this.xAxisBlockProvider = baseBlockProvider;
        this.zAxisBlockProvider = blockProvider;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.whitelist = whitelist.stream().map(class_4970.class_4971::method_26204).collect(Collectors.toSet());
    }

    public class_4651 getXAxisBlockProvider() {
        return this.xAxisBlockProvider;
    }

    public class_4651 getzAxisBlockProvider() {
        return this.zAxisBlockProvider;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMaxPossibleLength() {
        int returnValue = this.minLength - this.maxLength;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public Set<class_2248> getWhitelist() {
        return this.whitelist;
    }

    public static class Builder {
        private class_4651 xAxisBlockProvider = new class_4656(class_2246.field_10445.method_9564());
        private class_4651 zAxisBlockProvider = new class_4656(class_2246.field_10445.method_9564());
        private List<class_2248> whitelist = ImmutableList.of((Object)class_2246.field_10219);
        private int minLength = 1;
        private int maxLength = 9;

        public Builder setXAxisBlock(class_2248 block) {
            this.xAxisBlockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setXAxisBlock(class_2680 state) {
            this.xAxisBlockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setXAxisBlock(class_4651 provider) {
            this.xAxisBlockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setZAxisBlock(class_2248 block) {
            this.zAxisBlockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setZAxisBlock(class_2680 state) {
            this.zAxisBlockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setZAxisBlock(class_4651 provider) {
            this.zAxisBlockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setMinLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder setMaxLength(int maxPossibleHeight) {
            this.maxLength = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setWhitelist(ImmutableList<class_2248> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(ChainConfig config) {
            this.xAxisBlockProvider = config.xAxisBlockProvider;
            this.zAxisBlockProvider = config.zAxisBlockProvider;
            this.minLength = config.minLength;
            this.maxLength = config.maxLength;
            this.whitelist = ImmutableList.copyOf((Collection)config.whitelist);
            return this;
        }

        public ChainConfig build() {
            return new ChainConfig(this.xAxisBlockProvider, this.zAxisBlockProvider, this.minLength, this.maxLength, this.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()));
        }
    }
}

