/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.river;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.NoisyCaveSphereWater;
import corgiaoc.byg.common.world.feature.overworld.river.CanyonCache;
import corgiaoc.byg.common.world.feature.overworld.river.MegaChunk;
import corgiaoc.byg.common.world.feature.overworld.river.MegaChunkPos;
import corgiaoc.byg.common.world.feature.overworld.river.RiverGenerator;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_5281;

public class CanyonRiverWorldGenerator
extends class_3031<class_3111> {
    private static final int MAX_RIVER_DISTANCE = 512;
    private static final int MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS = -Math.floorDiv(-512, 256);
    private static long seed;
    private final Map<class_1937, CanyonCache> worldToCanyonPoint = new WeakHashMap<class_1937, CanyonCache>();
    public static FastNoise noise;

    public CanyonRiverWorldGenerator(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean place(class_5281 worldRegion, class_2794 generator, Random rand, class_2338 pos, class_3111 config) {
        CanyonRiverWorldGenerator.setupNoise(worldRegion.method_8412());
        NoisyCaveSphereWater.setSeed(worldRegion.method_8412());
        class_2791 chunk = worldRegion.method_22350(pos);
        class_1923 chunkPos = chunk.method_12004();
        CanyonCache canyonCache = this.worldToCanyonPoint.computeIfAbsent((class_1937)worldRegion.method_8410(), world -> new CanyonCache(worldRegion.method_8410().method_14178().method_12129(), Collections.singleton(worldRegion.method_30349().method_30530(class_2378.field_25114).method_29107(BYGBiomes.CANYON_KEY))));
        for (int xMegaScan = -MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; xMegaScan <= MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; ++xMegaScan) {
            for (int zMegaScan = -MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; zMegaScan <= MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; ++zMegaScan) {
                MegaChunkPos megaChunkPos = MegaChunkPos.fromBlockPos(pos).add(xMegaScan, zMegaScan);
                MegaChunk megaChunk = canyonCache.getMegaChunk(megaChunkPos);
                int count = megaChunk.getCount();
                if (count == 0) continue;
                RiverGenerator riverGenerator = megaChunk.getRiverGenerator();
                if (riverGenerator == null) {
                    if (!this.isMegaChunkWithMostCanyonChunks(megaChunk, canyonCache)) continue;
                    megaChunk.createRiverGeneratorStart(noise, worldRegion, worldRegion.method_8412(), 512);
                    riverGenerator = megaChunk.getRiverGenerator();
                }
                if (!riverGenerator.exists() || !riverGenerator.getNodeChunkPositions().contains(chunkPos)) continue;
                this.generateForChunk(worldRegion, chunkPos, riverGenerator);
            }
        }
        return true;
    }

    private void generateForChunk(class_5281 worldRegion, class_1923 chunkPos, RiverGenerator riverGenerator) {
        List<RiverGenerator.Node> nodes = riverGenerator.getNodesForChunk(chunkPos);
        for (int idx = 0; idx < nodes.size(); ++idx) {
            RiverGenerator.Node node = nodes.get(idx);
            RiverGenerator.Node prevNode = idx == 0 ? riverGenerator.getNodes().get(nodes.get(0).getIdx() - 1) : nodes.get(idx - 1);
            this.carveRiverNode(worldRegion, node, prevNode, riverGenerator);
        }
    }

    private void carveRiverNode(class_5281 worldRegion, RiverGenerator.Node node, RiverGenerator.Node prevNode, RiverGenerator riverGenerator) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)node.getPos());
        class_2338.class_2339 prevMutable = new class_2338.class_2339().method_10101((class_2382)prevNode.getPos());
        int xRadius = 10;
        int yRadius = 10;
        int zRadius = 10;
        int minXRadius = -xRadius;
        int minZRadius = -zRadius;
        int maxXRadius = xRadius;
        int maxZRadius = zRadius;
        int xDiff = mutable.method_10263() - prevMutable.method_10263();
        int zDiff = mutable.method_10260() - prevMutable.method_10260();
        if (xDiff > 0) {
            maxXRadius += xDiff;
        }
        if (zDiff > 0) {
            maxZRadius += zDiff;
        }
        if (xDiff < 0) {
            minXRadius += xDiff;
        }
        if (zDiff < 0) {
            minZRadius += zDiff;
        }
        class_2338.class_2339 mutable2 = new class_2338.class_2339().method_10101((class_2382)mutable);
        int yDiff = prevMutable.method_10264() - mutable.method_10264();
        for (int x = minXRadius; x <= maxXRadius; ++x) {
            for (int z = minZRadius; z <= maxZRadius; ++z) {
                mutable2.method_10101((class_2382)mutable).method_10100(x, 0, z);
                int height = worldRegion.method_8624(class_2902.class_2903.field_13195, mutable2.method_10263(), mutable2.method_10260());
                mutable2.method_10099(mutable2.method_10264() - 3);
                for (int y = -yRadius; y <= 25; ++y) {
                    double threshold;
                    class_2338 pos3 = mutable2.method_10069(0, y, 0);
                    if (y <= 0) {
                        double threshold2;
                        class_2680 state = class_2246.field_10382.method_9564();
                        double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                        if (equationResult >= (threshold2 = 1.0 + 0.7 * (double)NoisyCaveSphereWater.fastNoise.GetNoise(pos3.method_10263(), pos3.method_10264(), pos3.method_10260()))) continue;
                        if (this.isSolidAllAround(worldRegion, pos3)) {
                            worldRegion.method_8652(pos3, state, 2);
                            if (state.method_26204() != class_2246.field_10382) continue;
                            worldRegion.method_8405().method_8676(pos3, (Object)class_3612.field_15910, 0);
                            continue;
                        }
                        if (pos3.method_10264() > height) continue;
                        worldRegion.method_8652(pos3, class_2246.field_10340.method_9564(), 2);
                        continue;
                    }
                    double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                    if (equationResult >= (threshold = 1.0 + 0.7 * (double)NoisyCaveSphereWater.fastNoise.GetNoise(pos3.method_10263(), pos3.method_10264(), pos3.method_10260()))) continue;
                    class_2680 state = class_2246.field_10124.method_9564();
                    if (pos3.method_10264() + 5 <= height) continue;
                    worldRegion.method_8652(pos3, state, 2);
                }
            }
        }
    }

    private boolean isSolidAllAround(class_5281 worldRegion, class_2338 pos3) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 relative;
            class_2680 blockState;
            if (direction == class_2350.field_11036 || (blockState = worldRegion.method_8320(relative = pos3.method_10093(direction))).method_26207() == class_3614.field_15920 || blockState.method_26225()) continue;
            return false;
        }
        return true;
    }

    public boolean isMegaChunkWithMostCanyonChunks(MegaChunk megaChunk, CanyonCache canyonCache) {
        for (int xNeighborScan = -1; xNeighborScan <= 1; ++xNeighborScan) {
            for (int zNeighborScan = -1; zNeighborScan <= 1; ++zNeighborScan) {
                MegaChunkPos neighbor;
                MegaChunk neighborMegaChunk;
                if (xNeighborScan == 0 && zNeighborScan == 0 || (neighborMegaChunk = canyonCache.getMegaChunk(neighbor = megaChunk.getMegaChunkPos().add(xNeighborScan, zNeighborScan))).getCount() < megaChunk.getCount()) continue;
                return false;
            }
        }
        return true;
    }

    public static void setupNoise(long serverSeed) {
        if (seed != serverSeed || noise == null) {
            seed = serverSeed;
            noise = new FastNoise((int)seed);
            noise.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            noise.SetGradientPerturbAmp(1.0f);
            noise.SetFractalOctaves(5);
            noise.SetFractalGain(0.5f);
            noise.SetFrequency(0.015999999f);
        }
    }
}

