/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.structure.largefeature;

import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.world.BYGStructures;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3612;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public class VolcanoPiece
extends class_3443 {
    FastNoiseLite fnlPerlin;
    int baseRadius;
    double lavaLeakage;
    double threshold;
    int volcanoConeSize;
    int volcanoStartHeight;
    int volcanoSizeXMin;
    int volcanoSizeXMax;
    int volcanoSizeZMin;
    int volcanoSizeZMax;

    protected VolcanoPiece(class_2338 pos, int baseRadius, double lavaLeakage, int volcanoConeSize, int volcanoStartHeight, double threshold, FastNoiseLite fastNoiseLite, int volcanoConeSizeXMin, int volcanoConeSizeXMax, int volcanoConeSizeZMin, int volcanoConeSizeZMax) {
        super(BYGStructures.VOLCANO_PIECE, 0);
        this.field_15315 = new class_3341((class_2382)pos, (class_2382)pos);
        this.fnlPerlin = fastNoiseLite;
        this.baseRadius = baseRadius;
        this.volcanoConeSize = volcanoConeSize;
        this.lavaLeakage = lavaLeakage;
        this.volcanoStartHeight = volcanoStartHeight;
        this.threshold = threshold;
        this.volcanoSizeXMin = volcanoConeSizeXMin;
        this.volcanoSizeXMax = volcanoConeSizeXMax;
        this.volcanoSizeZMin = volcanoConeSizeZMin;
        this.volcanoSizeZMax = volcanoConeSizeZMax;
    }

    public VolcanoPiece(class_2487 nbt) {
        super(BYGStructures.VOLCANO_PIECE, nbt);
    }

    protected void method_14943(class_2487 tagCompound) {
    }

    public boolean method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 structureBoundingBox, class_1923 chunkPos, class_2338 aPos) {
        int yHeight = world.method_8624(class_2902.class_2903.field_13195, this.field_15315.field_14381, this.field_15315.field_14379);
        class_2338 pos = new class_2338(this.field_15315.field_14381, yHeight, this.field_15315.field_14379);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        double baseRadius = 25.0;
        double lavaLeakage = 0.7;
        int volcanoConeSize = 150;
        int volcanoStartHeight = volcanoConeSize - 5;
        double threshold = 0.5;
        class_3341 boundingBoxExpander = new class_3341();
        for (double x = (double)(-this.volcanoSizeXMin); x <= (double)this.volcanoSizeXMax; x += 1.0) {
            for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                for (double z = (double)(-this.volcanoSizeXMin); z <= (double)this.volcanoSizeZMax; z += 1.0) {
                    mutable.method_10101((class_2382)pos).method_10100((int)x, (int)y + volcanoStartHeight, (int)z);
                    float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.method_10263(), mutable.method_10260()));
                    double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                    if (scaledNoise - lavaLeakage >= threshold) {
                        if (mutable.method_10264() > pos.method_10264() + (volcanoStartHeight - 19)) continue;
                        world.method_8652((class_2338)mutable, class_2246.field_10164.method_9564(), 2);
                        world.method_8405().method_8676((class_2338)mutable, (Object)class_3612.field_15908, 0);
                        boundingBoxExpander.method_29299((class_2382)mutable);
                        continue;
                    }
                    if (!(scaledNoise >= threshold)) continue;
                    world.method_8652((class_2338)mutable, BYGBlocks.WARPED_CORAL_BLOCK.method_9564(), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

