/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder;

import com.mojang.serialization.Codec;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.util.SurfaceContext;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3523;
import net.minecraft.class_3527;
import net.minecraft.class_3532;

public class CanyonSurfaceBuilder
extends class_3523<class_3527> {
    private static long seed;
    public static FastNoise noise;
    public static FastNoise noise2;
    private static FastNoise noiseGrid;
    private static FastNoise octaveSimplexNoise;
    private static double max;
    private static double min;
    static int searchRange;
    private static final float[] CELL_WEIGHTS;
    SurfaceContext context = null;
    static int minColor;
    static int maxColor;
    static File file;
    static BufferedImage heightmapimage;

    private static void getMinAndMax(double noiseVal) {
        if (noiseVal > max) {
            max = noiseVal;
            BYG.LOGGER.info("BYG: Max Noise: " + max);
        }
        if (noiseVal < min) {
            min = noiseVal;
            BYG.LOGGER.info("BYG: Min noise: " + min);
        }
    }

    public CanyonSurfaceBuilder(Codec<class_3527> codec) {
        super(codec);
    }

    public void apply(Random random, class_2791 chunkIn, class_1959 biomeIn, int x, int z, int startHeight, double surfaceNoise, class_2680 defaultBlock, class_2680 defaultFluid, int seaLevel, long seed, class_3527 config) {
        boolean isFirstIteration;
        CanyonSurfaceBuilder.setupNoise(seed);
        class_2338.class_2339 localPos = new class_2338.class_2339().method_10103(x & 0xF, 0, z & 0xF);
        boolean isFinalIteration = localPos.method_10263() == 15 && localPos.method_10260() == 15;
        boolean bl = isFirstIteration = localPos.method_10263() == 0 && localPos.method_10260() == 0;
        if (isFirstIteration) {
            this.context = SurfaceContext.peek();
        }
        if (this.context == null) {
            return;
        }
        localPos.method_10099(chunkIn.method_12005(class_2902.class_2903.field_13195, localPos.method_10263(), localPos.method_10260()));
        chunkIn.method_12010((class_2338)localPos, BYGBlocks.OVERGROWN_STONE.method_9564(), false);
        if (isFinalIteration) {
            SurfaceContext.pop();
        }
    }

    public static void setupNoise(long serverSeed) {
        if (seed != serverSeed || noise == null || noise2 == null) {
            seed = serverSeed;
            noise = new FastNoise((int)seed);
            noise.SetFractalType(FastNoise.FractalType.RigidMulti);
            noise.SetNoiseType(FastNoise.NoiseType.CubicFractal);
            noise.SetGradientPerturbAmp(1.0f);
            noise.SetFractalOctaves(5);
            noise.SetFractalGain(0.3f);
            noise.SetFrequency(0.002f);
            noise2 = new FastNoise((int)seed);
            noise2.SetFractalType(FastNoise.FractalType.Billow);
            noise2.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            noise2.SetGradientPerturbAmp(1.0f);
            noise2.SetFractalOctaves(5);
            noise2.SetFractalGain(0.3f);
            noise2.SetFrequency(0.002f);
            noiseGrid = new FastNoise((int)seed);
            noiseGrid.SetNoiseType(FastNoise.NoiseType.Cellular);
            noiseGrid.SetFrequency(0.02f);
            noiseGrid.SetCellularReturnType(FastNoise.CellularReturnType.CellValue);
            octaveSimplexNoise = new FastNoise((int)seed);
            octaveSimplexNoise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            octaveSimplexNoise.SetFrequency(0.02f);
            octaveSimplexNoise.SetFractalOctaves(4);
        }
    }

    public static boolean checkForFlip(double min, double max) {
        return Math.abs(min) > Math.abs(max);
    }

    public static int readHeightmapData(int x, int z, int minY, int maxY) throws IOException {
        if (heightmapimage == null) {
            heightmapimage = ImageIO.read(file);
        }
        if (minColor == Integer.MAX_VALUE || maxColor == Integer.MIN_VALUE) {
            for (int xMove = 0; xMove < heightmapimage.getWidth(); ++xMove) {
                for (int zMove = 0; zMove < heightmapimage.getHeight(); ++zMove) {
                    int rgb = new Color(heightmapimage.getRGB(xMove, zMove)).getRed();
                    minColor = Math.min(minColor, rgb);
                    maxColor = Math.max(maxColor, rgb);
                }
            }
        }
        int rgb = heightmapimage.getRGB(Math.abs(x %= heightmapimage.getWidth() - 1), Math.abs(z %= heightmapimage.getHeight() - 1));
        rgb = new Color(rgb).getRed();
        return (rgb - minColor) * (maxY - minY) / (maxColor - minColor) + minY;
    }

    static {
        max = -1000.0;
        min = 10000.0;
        searchRange = 2;
        CELL_WEIGHTS = (float[])class_156.method_654((Object)new float[25], array -> {
            for (int i = -2; i < 2; ++i) {
                for (int j = -2; j < 2; ++j) {
                    float f;
                    array[i + 2 + (j + 2) * 5] = f = 10.0f / class_3532.method_15355((float)((float)(i * i + j * j) + 0.2f));
                }
            }
        });
        minColor = Integer.MAX_VALUE;
        maxColor = Integer.MIN_VALUE;
        file = new File("C:\\coding\\BYG\\src\\main\\resources\\assets\\byg\\canyon.jpg");
        heightmapimage = null;
    }
}

