/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.util;

import com.google.common.collect.Sets;
import corgiaoc.byg.util.MLBlockTags;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_4538;

public class BlockHelper {
    public static final class_2746 ROOTS = class_2746.method_11825((String)"roots");
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 19;
    public static final int SET_OBSERV = 3;
    public static final class_2350[] HORIZONTAL_DIRECTIONS = BlockHelper.makeHorizontal();
    public static final class_2350[] DIRECTIONS = class_2350.values();
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    protected static final class_2680 AIR = class_2246.field_10124.method_9564();
    protected static final class_2680 WATER = class_2246.field_10382.method_9564();

    public static int upRay(class_4538 world, class_2338 pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.method_22347(pos.method_10086(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(class_4538 world, class_2338 pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.method_22347(pos.method_10087(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRayRep(class_4538 world, class_2338 pos, int maxDist) {
        POS.method_10101((class_2382)pos);
        for (int j = 1; j < maxDist && world.method_8320((class_2338)POS).method_26207().method_15800(); ++j) {
            POS.method_10099(POS.method_10264() - 1);
        }
        return pos.method_10264() - POS.method_10264();
    }

    public static class_2350[] makeHorizontal() {
        return new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    }

    public static class_2350 randomHorizontal(Random random) {
        return HORIZONTAL_DIRECTIONS[random.nextInt(4)];
    }

    public static class_2350 randomDirection(Random random) {
        return DIRECTIONS[random.nextInt(6)];
    }

    public static class_2680 rotateHorizontal(class_2680 state, class_2470 rotation, class_2753 facing) {
        return (class_2680)state.method_11657((class_2769)facing, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)facing)));
    }

    public static class_2680 mirrorHorizontal(class_2680 state, class_2415 mirror, class_2753 facing) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)facing)));
    }

    public static class_2350 getRandomHorizontalDirection(Random rand) {
        return HORIZONTAL_DIRECTIONS[rand.nextInt(4)];
    }

    public static void setWithoutUpdate(class_1945 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 19);
    }

    public static void setWithUpdate(class_1945 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 3);
    }

    public static void setWithUpdate(class_1945 world, class_2338 pos, class_2248 block) {
        world.method_8652(pos, block.method_9564(), 3);
    }

    public static void setWithoutUpdate(class_1945 world, class_2338 pos, class_2248 block) {
        world.method_8652(pos, block.method_9564(), 19);
    }

    public static void fixBlocks(class_1936 world, class_2338 start, class_2338 end) {
        HashSet doubleCheck = Sets.newHashSet();
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_20787(x);
            for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                POS.method_20788(z);
                block2: for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                    POS.method_10099(y);
                    class_2680 state = world.method_8320((class_2338)POS);
                    if (!state.method_26227().method_15769()) {
                        if (!state.method_26184((class_4538)world, (class_2338)POS)) {
                            BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, WATER);
                            POS.method_10099(POS.method_10264() - 1);
                            state = world.method_8320((class_2338)POS);
                            while (!state.method_26184((class_4538)world, (class_2338)POS)) {
                                state = state.method_26227().method_15769() ? AIR : WATER;
                                BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, state);
                                POS.method_10099(POS.method_10264() - 1);
                                state = world.method_8320((class_2338)POS);
                            }
                        }
                        POS.method_10099(y - 1);
                        if (world.method_22347((class_2338)POS)) {
                            POS.method_10099(y);
                            while (!world.method_8316((class_2338)POS).method_15769()) {
                                BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, AIR);
                                POS.method_10099(POS.method_10264() + 1);
                            }
                            continue;
                        }
                        for (class_2350 dir : HORIZONTAL_DIRECTIONS) {
                            if (!world.method_22347(POS.method_10093(dir))) continue;
                            world.method_8405().method_8676((class_2338)POS, (Object)state.method_26227().method_15772(), 0);
                            continue block2;
                        }
                        continue;
                    }
                    if (state.method_26184((class_4538)world, (class_2338)POS)) continue;
                    if (state.method_27852(class_2246.field_10021)) {
                        HashSet ends = Sets.newHashSet();
                        HashSet add = Sets.newHashSet();
                        ends.add(POS.method_10062());
                        for (int i = 0; i < 64 && !ends.isEmpty(); ++i) {
                            ends.forEach(pos -> {
                                BlockHelper.setWithoutUpdate((class_1945)world, pos, AIR);
                                for (class_2350 dir : HORIZONTAL_DIRECTIONS) {
                                    class_2338 p = pos.method_10093(dir);
                                    class_2680 st = world.method_8320(p);
                                    if (!st.method_27852(class_2246.field_10021) && !st.method_27852(class_2246.field_10528) || st.method_26184((class_4538)world, p)) continue;
                                    add.add(p);
                                }
                                class_2338 p = pos.method_10084();
                                class_2680 st = world.method_8320(p);
                                if ((st.method_27852(class_2246.field_10021) || st.method_27852(class_2246.field_10528)) && !st.method_26184((class_4538)world, p)) {
                                    add.add(p);
                                }
                            });
                            ends.clear();
                            ends.addAll(add);
                            add.clear();
                        }
                        continue;
                    }
                    if (state.method_26204() instanceof class_2541) {
                        while (world.method_8320((class_2338)POS).method_26204() instanceof class_2541) {
                            BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, AIR);
                            POS.method_10099(POS.method_10264() - 1);
                        }
                        continue;
                    }
                    if (!(state.method_26204() instanceof class_2346)) continue;
                    class_2680 falling = state;
                    POS.method_10099(POS.method_10264() - 1);
                    state = world.method_8320((class_2338)POS);
                    int ray = BlockHelper.downRayRep((class_4538)world, POS.method_10062(), 64);
                    if (ray > 32) {
                        BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, class_2246.field_10471.method_9564());
                        if (!world.method_8409().nextBoolean()) continue;
                        POS.method_10099(POS.method_10264() - 1);
                        state = world.method_8320((class_2338)POS);
                        BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, class_2246.field_10471.method_9564());
                        continue;
                    }
                    POS.method_10099(y);
                    class_2680 replacement = AIR;
                    for (class_2350 dir : HORIZONTAL_DIRECTIONS) {
                        state = world.method_8320(POS.method_10093(dir));
                        if (state.method_26227().method_15769()) continue;
                        replacement = state;
                        break;
                    }
                    BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, replacement);
                    POS.method_10099(y - ray);
                    BlockHelper.setWithoutUpdate((class_1945)world, (class_2338)POS, falling);
                }
            }
        }
        doubleCheck.forEach(pos -> {
            if (!world.method_8320(pos).method_26184((class_4538)world, pos)) {
                BlockHelper.setWithoutUpdate((class_1945)world, pos, AIR);
            }
        });
    }

    private static class_2680 getAirOrFluid(class_2680 state) {
        return state.method_26227().method_15769() ? AIR : state.method_26227().method_15759();
    }

    public static boolean isEndNylium(class_2248 block) {
        return block.method_9525((class_3494)class_3481.field_21953) && block.method_9525(MLBlockTags.END_STONES);
    }

    public static boolean isEndNylium(class_2680 state) {
        return BlockHelper.isEndNylium(state.method_26204());
    }
}

