/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.util.noise.worley;

import java.util.Random;

public abstract class Noise {
    private static final int CHAR_BIT = 8;
    private static final int SIZE_INT = 8;

    public Noise(Random seed) {
    }

    public static double fastSqrt(double d) {
        return Double.longBitsToDouble((Double.doubleToLongBits(d) - 0x10000000000000L >> 1) + 0x2000000000000000L);
    }

    public static int fastAbs(int n) {
        int mask = n >> 63;
        return n + mask ^ mask;
    }

    public static long fastAbs(long n) {
        long mask = n >> 63;
        return n + mask ^ mask;
    }

    protected static int factorial(int n) {
        if (n == 1) {
            return 1;
        }
        return n * Noise.factorial(n - 1);
    }

    protected static double lerp(double progress, double start, double end) {
        return start + progress * (end - start);
    }

    protected static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public abstract double sample2D(double var1, double var3);

    public abstract double sample3D(double var1, double var3, double var5);

    protected double clamp(double value) {
        return value > 1.0 ? 1.0 : (value < -1.0 ? -1.0 : value);
    }

    protected double clampPositive(double value) {
        return value < 0.0 ? 0.0 : value;
    }
}

