/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSlotWaypoints;
import com.mamiyaotaru.voxelmap.gui.GuiWaypointsOptions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class GuiWaypoints
extends GuiScreenMinimap
implements IGuiWaypoints {
    private final class_437 parentScreen;
    private IVoxelMap master;
    protected final MapSettingsManager options;
    protected final IWaypointManager waypointManager;
    protected class_2561 screenTitle;
    private GuiSlotWaypoints waypointList;
    private class_4185 buttonEdit;
    private boolean editClicked = false;
    private class_4185 buttonDelete;
    private boolean deleteClicked = false;
    private class_4185 buttonHighlight;
    private class_4185 buttonShare;
    private class_4185 buttonTeleport;
    private class_4185 buttonSortName;
    private class_4185 buttonSortCreated;
    private class_4185 buttonSortDistance;
    private class_4185 buttonSortColor;
    protected class_342 filter;
    private boolean addClicked = false;
    private class_2561 tooltip = null;
    protected Waypoint selectedWaypoint = null;
    protected Waypoint highlightedWaypoint = null;
    protected Waypoint newWaypoint = null;
    private Random generator = new Random();
    private boolean changedSort = false;

    public GuiWaypoints(class_437 parentScreen, IVoxelMap master) {
        this.master = master;
        this.parentScreen = parentScreen;
        this.options = master.getMapOptions();
        this.waypointManager = master.getWaypointManager();
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
    }

    public void method_25393() {
        this.filter.method_1865();
    }

    public void method_25426() {
        boolean isSomethingSelected;
        this.screenTitle = new class_2588("minimap.waypoints.title");
        this.getMinecraft().field_1774.method_1462(true);
        this.waypointList = new GuiSlotWaypoints(this);
        this.buttonSortName = new class_4185(this.getWidth() / 2 - 154, 34, 77, 20, (class_2561)new class_2588("minimap.waypoints.sortbyname"), button -> {
            Objects.requireNonNull(this.options);
            this.sortClicked(2);
        });
        this.method_37063((class_364)this.buttonSortName);
        this.buttonSortDistance = new class_4185(this.getWidth() / 2 - 77, 34, 77, 20, (class_2561)new class_2588("minimap.waypoints.sortbydistance"), button -> {
            Objects.requireNonNull(this.options);
            this.sortClicked(3);
        });
        this.method_37063((class_364)this.buttonSortDistance);
        this.buttonSortCreated = new class_4185(this.getWidth() / 2, 34, 77, 20, (class_2561)new class_2588("minimap.waypoints.sortbycreated"), button -> {
            Objects.requireNonNull(this.options);
            this.sortClicked(1);
        });
        this.method_37063((class_364)this.buttonSortCreated);
        this.buttonSortColor = new class_4185(this.getWidth() / 2 + 77, 34, 77, 20, (class_2561)new class_2588("minimap.waypoints.sortbycolor"), button -> {
            Objects.requireNonNull(this.options);
            this.sortClicked(4);
        });
        this.method_37063((class_364)this.buttonSortColor);
        int filterStringWidth = this.getFontRenderer().method_1727(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 80, 305 - filterStringWidth - 5, 20, null);
        this.filter.method_1880(35);
        this.method_37063((class_364)this.filter);
        this.buttonEdit = new class_4185(this.getWidth() / 2 - 154, this.getHeight() - 52, 74, 20, (class_2561)new class_2588("selectServer.edit"), button -> this.editWaypoint(this.selectedWaypoint));
        this.method_37063((class_364)this.buttonEdit);
        this.buttonDelete = new class_4185(this.getWidth() / 2 - 76, this.getHeight() - 52, 74, 20, (class_2561)new class_2588("selectServer.delete"), button -> this.deleteClicked());
        this.method_37063((class_364)this.buttonDelete);
        this.buttonHighlight = new class_4185(this.getWidth() / 2 + 2, this.getHeight() - 52, 74, 20, (class_2561)new class_2588("minimap.waypoints.highlight"), button -> this.setHighlightedWaypoint());
        this.method_37063((class_364)this.buttonHighlight);
        this.buttonTeleport = new class_4185(this.getWidth() / 2 + 80, this.getHeight() - 52, 74, 20, (class_2561)new class_2588("minimap.waypoints.teleportto"), button -> this.teleportClicked());
        this.method_37063((class_364)this.buttonTeleport);
        this.buttonShare = new class_4185(this.getWidth() / 2 - 154, this.getHeight() - 28, 74, 20, (class_2561)new class_2588("minimap.waypoints.share"), button -> CommandUtils.sendWaypoint(this.selectedWaypoint));
        this.method_37063((class_364)this.buttonShare);
        this.method_37063((class_364)new class_4185(this.getWidth() / 2 - 76, this.getHeight() - 28, 74, 20, (class_2561)new class_2588("minimap.waypoints.newwaypoint"), button -> this.addWaypoint()));
        this.method_37063((class_364)new class_4185(this.getWidth() / 2 + 2, this.getHeight() - 28, 74, 20, (class_2561)new class_2588("menu.options"), button -> this.getMinecraft().method_1507((class_437)new GuiWaypointsOptions(this, this.options))));
        this.method_37063((class_364)new class_4185(this.getWidth() / 2 + 80, this.getHeight() - 28, 74, 20, (class_2561)new class_2588("gui.done"), button -> this.getMinecraft().method_1507(this.parentScreen)));
        this.method_25395((class_364)this.filter);
        this.filter.method_1876(true);
        this.buttonEdit.field_22763 = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_22763 = isSomethingSelected;
        this.buttonHighlight.field_22763 = isSomethingSelected;
        this.buttonShare.field_22763 = isSomethingSelected;
        this.buttonTeleport.field_22763 = isSomethingSelected && this.canTeleport();
        this.sort();
    }

    private void sort() {
        int sortKey = Math.abs(this.options.sort);
        boolean ascending = this.options.sort > 0;
        this.waypointList.sortBy(sortKey, ascending);
        String arrow = ascending ? "\u2191" : "\u2193";
        Objects.requireNonNull(this.options);
        if (sortKey == 2) {
            this.buttonSortName.method_25355((class_2561)new class_2585(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortName.method_25355((class_2561)new class_2588("minimap.waypoints.sortbyname"));
        }
        Objects.requireNonNull(this.options);
        if (sortKey == 3) {
            this.buttonSortDistance.method_25355((class_2561)new class_2585(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortDistance.method_25355((class_2561)new class_2588("minimap.waypoints.sortbydistance"));
        }
        Objects.requireNonNull(this.options);
        if (sortKey == 1) {
            this.buttonSortCreated.method_25355((class_2561)new class_2585(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortCreated.method_25355((class_2561)new class_2588("minimap.waypoints.sortbycreated"));
        }
        Objects.requireNonNull(this.options);
        if (sortKey == 4) {
            this.buttonSortColor.method_25355((class_2561)new class_2585(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortColor.method_25355((class_2561)new class_2588("minimap.waypoints.sortbycolor"));
        }
    }

    private void deleteClicked() {
        String var2 = this.selectedWaypoint.name;
        if (var2 != null) {
            this.deleteClicked = true;
            class_2588 title = new class_2588("minimap.waypoints.deleteconfirm");
            class_2588 explanation = new class_2588("selectServer.deleteWarning", new Object[]{var2});
            class_2588 affirm = new class_2588("selectServer.deleteButton");
            class_2588 deny = new class_2588("gui.cancel");
            class_410 confirmScreen = new class_410((BooleanConsumer)this, (class_2561)title, (class_2561)explanation, (class_2561)affirm, (class_2561)deny);
            this.getMinecraft().method_1507((class_437)confirmScreen);
        }
    }

    private void teleportClicked() {
        boolean mp;
        boolean bl = mp = !this.field_22787.method_1496();
        int y = this.selectedWaypoint.getY() > 0 ? this.selectedWaypoint.getY() : (!this.options.game.field_1724.field_6002.method_8597().method_27998() ? 255 : 64);
        this.options.game.field_1724.method_3142("/tp " + this.options.game.field_1724.method_5477().getString() + " " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
        if (mp) {
            this.options.game.field_1724.method_3142("/tppos " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
        }
        this.getMinecraft().method_1507((class_437)null);
    }

    protected void sortClicked(int id) {
        this.options.setSort(id);
        this.changedSort = true;
        this.sort();
    }

    public boolean method_25404(int keysm, int scancode, int b) {
        boolean OK = super.method_25404(keysm, scancode, b);
        if (this.filter.method_25370()) {
            this.waypointList.updateFilter(this.filter.method_1882().toLowerCase());
        }
        return OK;
    }

    public boolean method_25400(char character, int keycode) {
        boolean OK = super.method_25400(character, keycode);
        if (this.filter.method_25370()) {
            this.waypointList.updateFilter(this.filter.method_1882().toLowerCase());
        }
        return OK;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.method_25402(mouseX, mouseY, mouseButton);
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.method_25406(mouseX, mouseY, mouseButton);
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.waypointList.method_25403(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.waypointList.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean par1) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
            this.getMinecraft().method_1507((class_437)this);
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                this.waypointManager.saveWaypoints();
            }
            this.getMinecraft().method_1507((class_437)this);
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.waypointManager.addWaypoint(this.newWaypoint);
                this.setSelectedWaypoint(this.newWaypoint);
            }
            this.getMinecraft().method_1507((class_437)this);
        }
    }

    protected void setSelectedWaypoint(Waypoint waypoint) {
        boolean isSomethingSelected;
        this.selectedWaypoint = waypoint;
        this.buttonEdit.field_22763 = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_22763 = isSomethingSelected;
        this.buttonHighlight.field_22763 = isSomethingSelected;
        this.buttonHighlight.method_25355((class_2561)new class_2588(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight"));
        this.buttonShare.field_22763 = isSomethingSelected;
        this.buttonTeleport.field_22763 = isSomethingSelected && this.canTeleport();
    }

    protected void setHighlightedWaypoint() {
        this.waypointManager.setHighlightedWaypoint(this.selectedWaypoint, true);
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
        boolean isSomethingSelected = this.selectedWaypoint != null;
        this.buttonHighlight.method_25355((class_2561)new class_2588(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight"));
    }

    protected void editWaypoint(Waypoint waypoint) {
        this.editClicked = true;
        this.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, this.master, waypoint, true));
    }

    protected void addWaypoint() {
        float b;
        float g;
        float r;
        this.addClicked = true;
        if (this.waypointManager.getWaypoints().size() == 0) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = this.generator.nextFloat();
            g = this.generator.nextFloat();
            b = this.generator.nextFloat();
        }
        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
        dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByWorld((class_1937)this.getMinecraft().field_1687));
        double dimensionScale = this.options.game.field_1724.field_6002.method_8597().method_31110();
        this.newWaypoint = new Waypoint("", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord(), true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
        this.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, this.master, this.newWaypoint, false));
    }

    protected void toggleWaypointVisibility() {
        this.selectedWaypoint.enabled = !this.selectedWaypoint.enabled;
        this.waypointManager.saveWaypoints();
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        this.tooltip = null;
        this.waypointList.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        GuiWaypoints.method_27534((class_4587)matrixStack, (class_327)this.getFontRenderer(), (class_2561)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        GuiWaypoints.method_25303((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":"), (int)(this.getWidth() / 2 - 153), (int)(this.getHeight() - 75), (int)0xA0A0A0);
        this.filter.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        if (this.tooltip != null) {
            this.method_25424(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    static class_2561 setTooltip(GuiWaypoints par0GuiWaypoints, class_2561 par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    public boolean canTeleport() {
        boolean allowed = false;
        boolean singlePlayer = this.options.game.method_1496();
        if (singlePlayer) {
            try {
                allowed = this.getMinecraft().method_1576().method_3760().method_14569(this.getMinecraft().field_1724.method_7334());
            }
            catch (Exception e) {
                allowed = this.getMinecraft().method_1576().method_27728().method_194();
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    @Override
    public void method_25432() {
        this.field_22787.field_1774.method_1462(false);
        if (this.changedSort) {
            super.method_25432();
        }
    }
}

