/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1923;

public class ChunkAdjacencyMap {
    private final Long2ReferenceMap<LongSet> map = new Long2ReferenceOpenHashMap();

    public boolean hasNeighbors(int x, int z) {
        LongSet set = (LongSet)this.map.get(class_1923.method_8331((int)x, (int)z));
        if (set == null) {
            return false;
        }
        return set.size() >= 9;
    }

    public void onChunkLoaded(int x, int z) {
        long pos = class_1923.method_8331((int)x, (int)z);
        for (int xd = -1; xd <= 1; ++xd) {
            for (int zd = -1; zd <= 1; ++zd) {
                this.add(x + xd, z + zd, pos);
            }
        }
    }

    public void onChunkUnloaded(int x, int z) {
        long pos = class_1923.method_8331((int)x, (int)z);
        for (int xd = -1; xd <= 1; ++xd) {
            for (int zd = -1; zd <= 1; ++zd) {
                this.remove(x + xd, z + zd, pos);
            }
        }
    }

    private void add(int x, int z, long pos) {
        long key = class_1923.method_8331((int)x, (int)z);
        LongSet set = (LongSet)this.map.get(key);
        if (set == null) {
            set = new LongArraySet(8);
            this.map.put(key, (Object)set);
        }
        if (!set.add(pos)) {
            throw new IllegalStateException();
        }
    }

    private void remove(int x, int z, long pos) {
        long key = class_1923.method_8331((int)x, (int)z);
        LongSet set = (LongSet)this.map.get(key);
        if (set == null) {
            throw new NullPointerException();
        }
        if (!set.remove(pos)) {
            throw new IllegalStateException();
        }
        if (set.isEmpty()) {
            this.map.remove(key);
        }
    }
}

