/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.okzoomer.config;

import io.github.ennuil.libzoomer.api.MouseModifier;
import io.github.ennuil.libzoomer.api.TransitionMode;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.libzoomer.api.modifiers.CinematicCameraMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ContainingMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.NoMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ZoomDivisorMouseModifier;
import io.github.ennuil.libzoomer.api.overlays.NoZoomOverlay;
import io.github.ennuil.libzoomer.api.transitions.InstantTransitionMode;
import io.github.ennuil.libzoomer.api.transitions.SmoothTransitionMode;
import io.github.ennuil.okzoomer.config.OkZoomerConfigPojo;
import io.github.ennuil.okzoomer.packets.ZoomPackets;
import io.github.ennuil.okzoomer.utils.ZoomUtils;
import io.github.ennuil.okzoomer.zoom.LinearTransitionMode;
import io.github.ennuil.okzoomer.zoom.MultipliedCinematicCameraMouseModifier;
import io.github.ennuil.okzoomer.zoom.ZoomerZoomOverlay;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.SettingNamingConvention;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class OkZoomerConfig {
    public static boolean isConfigLoaded = false;
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("okzoomer.json5");
    private static final AnnotatedSettings ANNOTATED_SETTINGS = AnnotatedSettings.builder().useNamingConvention(SettingNamingConvention.SNAKE_CASE).build();
    private static final OkZoomerConfigPojo POJO = new OkZoomerConfigPojo();
    public static final ConfigTree TREE = ConfigTree.builder().applyFromPojo((Object)POJO, ANNOTATED_SETTINGS).build();
    private static JanksonValueSerializer serializer = new JanksonValueSerializer(false);

    public static void loadModConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                ANNOTATED_SETTINGS.applyToNode(TREE, (Object)POJO);
                FiberSerialization.deserialize((ConfigTree)TREE, (InputStream)Files.newInputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
                OkZoomerConfig.configureZoomInstance();
                isConfigLoaded = true;
            }
            catch (FiberException | IOException e) {
                e.printStackTrace();
            }
        } else {
            OkZoomerConfig.saveModConfig();
            isConfigLoaded = true;
        }
    }

    public static void saveModConfig() {
        try {
            ANNOTATED_SETTINGS.applyToNode(TREE, (Object)POJO);
            FiberSerialization.serialize((ConfigTree)TREE, (OutputStream)Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
            OkZoomerConfig.configureZoomInstance();
        }
        catch (FiberException | IOException e) {
            e.printStackTrace();
        }
    }

    public static void configureZoomInstance() {
        ZoomUtils.zoomerZoom.setTransitionMode((TransitionMode)(switch (OkZoomerConfigPojo.features.zoomTransition) {
            case OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode((float)OkZoomerConfigPojo.values.smoothMultiplier);
            case OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode(OkZoomerConfigPojo.values.minimumLinearStep, OkZoomerConfigPojo.values.maximumLinearStep);
            default -> new InstantTransitionMode();
        }));
        if (ZoomPackets.getForceClassicMode()) {
            ZoomUtils.zoomerZoom.setDefaultZoomDivisor(4.0);
            ZoomUtils.zoomerZoom.setMouseModifier((MouseModifier)new CinematicCameraMouseModifier());
            ZoomUtils.zoomerZoom.setZoomOverlay((ZoomOverlay)new NoZoomOverlay());
            return;
        }
        ZoomUtils.zoomerZoom.setDefaultZoomDivisor(OkZoomerConfigPojo.values.zoomDivisor);
        OkZoomerConfig.configureZoomModifier();
        ZoomUtils.zoomerZoom.setZoomOverlay((ZoomOverlay)(OkZoomerConfigPojo.features.zoomOverlay ? new ZoomerZoomOverlay() : new NoZoomOverlay()));
    }

    public static void configureZoomModifier() {
        OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions cinematicCamera = OkZoomerConfigPojo.features.cinematicCamera;
        boolean reduceSensitivity = OkZoomerConfigPojo.features.reduceSensitivity;
        if (cinematicCamera != OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions.OFF) {
            Object cinematicModifier = switch (cinematicCamera) {
                case OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier(OkZoomerConfigPojo.values.cinematicMultiplier);
                default -> null;
            };
            ZoomUtils.zoomerZoom.setMouseModifier((MouseModifier)(reduceSensitivity ? new ContainingMouseModifier(new MouseModifier[]{cinematicModifier, new ZoomDivisorMouseModifier()}) : cinematicModifier));
        } else {
            ZoomUtils.zoomerZoom.setMouseModifier((MouseModifier)(reduceSensitivity ? new ZoomDivisorMouseModifier() : new NoMouseModifier()));
        }
    }

    public static void resetToPreset(ZoomPresets preset) {
        OkZoomerConfigPojo.features.cinematicCamera = switch (preset) {
            case ZoomPresets.CLASSIC -> OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions.VANILLA;
            default -> OkZoomerConfigPojo.FeaturesGroup.CinematicCameraOptions.OFF;
        };
        OkZoomerConfigPojo.features.reduceSensitivity = switch (preset) {
            case ZoomPresets.CLASSIC -> false;
            default -> true;
        };
        OkZoomerConfigPojo.features.zoomTransition = switch (preset) {
            case ZoomPresets.CLASSIC -> OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.OFF;
            default -> OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.SMOOTH;
        };
        OkZoomerConfigPojo.features.zoomMode = switch (preset) {
            case ZoomPresets.PERSISTENT -> OkZoomerConfigPojo.FeaturesGroup.ZoomModes.PERSISTENT;
            default -> OkZoomerConfigPojo.FeaturesGroup.ZoomModes.HOLD;
        };
        OkZoomerConfigPojo.features.zoomScrolling = switch (preset) {
            case ZoomPresets.CLASSIC -> false;
            default -> true;
        };
        OkZoomerConfigPojo.features.extraKeybinds = switch (preset) {
            case ZoomPresets.CLASSIC -> false;
            default -> true;
        };
        OkZoomerConfigPojo.values.zoomDivisor = switch (preset) {
            case ZoomPresets.PERSISTENT -> 1.0;
            default -> 4.0;
        };
        OkZoomerConfigPojo.tweaks.resetZoomWithMouse = switch (preset) {
            case ZoomPresets.CLASSIC -> false;
            default -> true;
        };
        OkZoomerConfigPojo.features.zoomOverlay = false;
        OkZoomerConfigPojo.values.minimumZoomDivisor = 1.0;
        OkZoomerConfigPojo.values.maximumZoomDivisor = 50.0;
        OkZoomerConfigPojo.values.scrollStep = 1.0;
        OkZoomerConfigPojo.values.lesserScrollStep = 0.5;
        OkZoomerConfigPojo.values.cinematicMultiplier = 4.0;
        OkZoomerConfigPojo.values.smoothMultiplier = 0.75;
        OkZoomerConfigPojo.values.minimumLinearStep = 0.125;
        OkZoomerConfigPojo.values.maximumLinearStep = 0.25;
        OkZoomerConfigPojo.tweaks.printOwoOnStart = true;
    }

    public static enum ZoomPresets {
        DEFAULT,
        CLASSIC,
        PERSISTENT;

    }
}

