/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world;

import com.yungnickyoung.minecraft.yungsapi.YungsApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public class ItemSetSelector {
    private Map<class_1792, Float> entries = new HashMap<class_1792, Float>();
    private class_1792 defaultItem = class_1802.field_8162;

    public ItemSetSelector(class_1792 defaultItem) {
        this.defaultItem = defaultItem;
    }

    public ItemSetSelector() {
    }

    public static ItemSetSelector from(class_1792 ... items) {
        ItemSetSelector selector = new ItemSetSelector();
        float chance = 1.0f / (float)items.length;
        for (class_1792 item : items) {
            selector.addItem(item, chance);
        }
        return selector;
    }

    public ItemSetSelector addItem(class_1792 item, float chance) {
        if (this.entries.containsKey(item)) {
            YungsApi.LOGGER.warn(String.format("WARNING: duplicate item %s added to ItemSetSelector!", item.toString()));
            return this;
        }
        float currTotal = this.entries.values().stream().reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApi.LOGGER.warn(String.format("WARNING: item %s added to ItemSetSelector exceeds max probabiltiy of 1!", item.toString()));
            return this;
        }
        this.entries.put(item, Float.valueOf(chance));
        return this;
    }

    public class_1792 get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Map.Entry<class_1792, Float> entry : this.entries.entrySet()) {
            float chance = entry.getValue().floatValue();
            if (currBottom <= target && target < currBottom + chance) {
                return entry.getKey();
            }
            currBottom += chance;
        }
        return this.defaultItem;
    }

    public void setDefaultItem(class_1792 item) {
        this.defaultItem = item;
    }

    public Map<class_1792, Float> getEntries() {
        return this.entries;
    }

    public class_1792 getDefaultItem() {
        return this.defaultItem;
    }
}

