/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.biome;

import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.config.json.biomedata.OverworldPrimaryBiomeData;
import corgiaoc.byg.mixin.access.BiomeAccess;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import corgiaoc.byg.mixin.access.WeightedListEntryAccess;
import corgiaoc.byg.util.MLClimate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4131;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_5485;

public class BYGBiome {
    public static final List<BYGBiome> BYG_BIOMES = new ArrayList<BYGBiome>();
    private final class_1959 biome;
    public static final Map<class_2960, class_4131<class_2960>> BIOME_TO_HILLS_LIST = new HashMap<class_2960, class_4131<class_2960>>();
    public static final Map<class_2960, class_2960> BIOME_TO_BEACH_LIST = new HashMap<class_2960, class_2960>();
    public static final Map<class_2960, class_2960> BIOME_TO_EDGE_LIST = new HashMap<class_2960, class_2960>();
    public static final Map<class_2960, class_2960> BIOME_TO_RIVER_LIST = new HashMap<class_2960, class_2960>();

    public BYGBiome(class_1959.class_5482 climate, class_1959.class_1961 category, float depth, float scale, class_4763 effects, class_5485 biomeGenerationSettings, class_5483 mobSpawnInfo) {
        this.biome = BiomeAccess.create(climate, category, depth, scale, effects, biomeGenerationSettings, mobSpawnInfo);
        BYG_BIOMES.add(this);
    }

    public BYGBiome(class_1959.class_1960 builder) {
        this.biome = builder.method_30972();
        BYG_BIOMES.add(this);
    }

    public BYGBiome(class_1959 biome) {
        this.biome = biome;
        BYG_BIOMES.add(this);
    }

    public class_1959 getBiome() {
        return this.biome;
    }

    public class_1959 getRiver() {
        return (class_1959)class_5458.field_25933.method_31140(class_1972.field_9438);
    }

    public class_4131<class_1959> getHills() {
        return new class_4131();
    }

    @Nullable
    public class_1959 getEdge() {
        return null;
    }

    @Nullable
    public class_1959 getBeach() {
        return (class_1959)class_5458.field_25933.method_31140(class_1972.field_9434);
    }

    public String[] getBiomeDictionary() {
        return new String[]{"OVERWORLD"};
    }

    public MLClimate getClimate() {
        return MLClimate.WARM;
    }

    public int getWeight() {
        return 5;
    }

    public static BiomeDataHolders.OverworldPrimaryBiomeDataHolder extractDefaultHolder() {
        HashMap<class_2960, OverworldPrimaryBiomeData> biomeData = new HashMap<class_2960, OverworldPrimaryBiomeData>();
        for (BYGBiome bygBiome : BYG_BIOMES) {
            class_4131 weightedListByLocation = new class_4131();
            for (class_4131.class_4132 entry : ((WeightedListAccess)bygBiome.getHills()).getEntries()) {
                weightedListByLocation.method_19031((Object)class_5458.field_25933.method_10221(entry.method_19035()), ((WeightedListEntryAccess)entry).getWeight());
            }
            biomeData.put(class_5458.field_25933.method_10221((Object)bygBiome.getBiome()), new OverworldPrimaryBiomeData(bygBiome.getClimate(), bygBiome.getWeight(), Arrays.asList(bygBiome.getBiomeDictionary()), (class_4131<class_2960>)weightedListByLocation, bygBiome.getEdge() != null ? class_5458.field_25933.method_10221((Object)bygBiome.getEdge()) : new class_2960(""), class_5458.field_25933.method_10221((Object)bygBiome.getBeach()), class_5458.field_25933.method_10221((Object)bygBiome.getRiver())));
        }
        return new BiomeDataHolders.OverworldPrimaryBiomeDataHolder((Map<class_2960, OverworldPrimaryBiomeData>)biomeData);
    }

    public class_5321<class_1959> getKey() {
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)Objects.requireNonNull(class_5458.field_25933.method_10221((Object)this.biome)));
    }
}

