/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultrusbot.moborigins.entity.peddler;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class CustomTradeOffers {
    public static final Int2ObjectMap<Factory[]> WANDERING_TRADER_TRADES = CustomTradeOffers.copyToFastUtilMap((ImmutableMap<Integer, Factory[]>)ImmutableMap.of((Object)1, (Object)new Factory[]{new SellItemFactory(class_1802.field_8880, 1, 1, 12, 1), new SellItemFactory(class_1802.field_8773, 8, 1, 4, 1), new SellItemFactory(class_1802.field_17519, 3, 1, 4, 1), new SellItemFactory(class_1802.field_8884, 3, 1, 4, 1), new SellItemFactory(class_1802.field_8399, 6, 1, 2, 1), new SellItemFactory(class_1802.field_8620, 6, 2, 3, 1), new MysteryMeatFactory(class_1802.field_8046, 2, 4, 4, 1), new MysteryMeatFactory(class_1802.field_8726, 2, 4, 4, 1), new MysteryMeatFactory(class_1802.field_8389, 2, 4, 4, 1), new MysteryMeatFactory(class_1802.field_8504, 2, 4, 4, 1), new MysteryMeatFactory(class_1802.field_8748, 2, 4, 4, 1)}, (Object)2, (Object)new Factory[]{new SellItemFactory(class_1802.field_8626, 1, 4, 3, 1), new SellEnchantedToolFactory(class_1802.field_8475, 16, 1, 6), new SellEnchantedToolFactory(class_1802.field_8399, 16, 1, 6)}));

    private static Int2ObjectMap<Factory[]> copyToFastUtilMap(ImmutableMap<Integer, Factory[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static interface Factory {
        @Nullable
        public class_1914 create(class_1297 var1, Random var2);
    }

    static class BuyForOneEmeraldFactory
    implements Factory {
        private final class_1792 buy;
        private final int price;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public BuyForOneEmeraldFactory(class_1935 item, int price, int maxUses, int experience) {
            this.buy = item.method_8389();
            this.price = price;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = 0.05f;
        }

        @Override
        public class_1914 create(class_1297 entity, Random random) {
            class_1799 itemStack = new class_1799((class_1935)this.buy, this.price);
            return new class_1914(itemStack, new class_1799((class_1935)class_1802.field_8687), this.maxUses, this.experience, this.multiplier);
        }
    }

    static class SellItemFactory
    implements Factory {
        private final class_1799 sell;
        private final int price;
        private final int count;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellItemFactory(class_2248 block, int price, int count, int maxUses, int experience) {
            this(new class_1799((class_1935)block), price, count, maxUses, experience);
        }

        public SellItemFactory(class_1792 item, int price, int count, int experience) {
            this(new class_1799((class_1935)item), price, count, 12, experience);
        }

        public SellItemFactory(class_1792 item, int price, int count, int maxUses, int experience) {
            this(new class_1799((class_1935)item), price, count, maxUses, experience);
        }

        public SellItemFactory(class_1799 stack, int price, int count, int maxUses, int experience) {
            this(stack, price, count, maxUses, experience, 0.05f);
        }

        public SellItemFactory(class_1799 stack, int price, int count, int maxUses, int experience, float multiplier) {
            this.sell = stack;
            this.price = price;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        @Override
        public class_1914 create(class_1297 entity, Random random) {
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.price), new class_1799((class_1935)this.sell.method_7909(), this.count), this.maxUses, this.experience, this.multiplier);
        }
    }

    static class SellSuspiciousStewFactory
    implements Factory {
        final class_1291 effect;
        final int duration;
        final int experience;
        private final float multiplier;

        public SellSuspiciousStewFactory(class_1291 effect, int duration, int experience) {
            this.effect = effect;
            this.duration = duration;
            this.experience = experience;
            this.multiplier = 0.05f;
        }

        @Override
        @Nullable
        public class_1914 create(class_1297 entity, Random random) {
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8766, 1);
            class_1830.method_8021((class_1799)itemStack, (class_1291)this.effect, (int)this.duration);
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, 1), itemStack, 12, this.experience, this.multiplier);
        }
    }

    static class SellEnchantedToolFactory
    implements Factory {
        private final class_1799 tool;
        private final int basePrice;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellEnchantedToolFactory(class_1792 item, int basePrice, int maxUses, int experience) {
            this(item, basePrice, maxUses, experience, 0.05f);
        }

        public SellEnchantedToolFactory(class_1792 item, int basePrice, int maxUses, int experience, float multiplier) {
            this.tool = new class_1799((class_1935)item);
            this.basePrice = basePrice;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        @Override
        public class_1914 create(class_1297 entity, Random random) {
            int i = 5 + random.nextInt(15);
            class_1799 itemStack = class_1890.method_8233((Random)random, (class_1799)new class_1799((class_1935)this.tool.method_7909()), (int)i, (boolean)false);
            int j = Math.min(this.basePrice + i, 64);
            class_1799 itemStack2 = new class_1799((class_1935)class_1802.field_8687, j);
            return new class_1914(itemStack2, itemStack, this.maxUses, this.experience, this.multiplier);
        }
    }

    static class MysteryMeatFactory
    implements Factory {
        private final class_1799 sell;
        private final int price;
        private final int count;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public MysteryMeatFactory(class_1792 item, int price, int count, int experience) {
            this(new class_1799((class_1935)item), price, count, 12, experience);
        }

        public MysteryMeatFactory(class_1792 item, int price, int count, int maxUses, int experience) {
            this(new class_1799((class_1935)item), price, count, maxUses, experience);
        }

        public MysteryMeatFactory(class_1799 stack, int price, int count, int maxUses, int experience) {
            this(stack, price, count, maxUses, experience, 0.05f);
        }

        public MysteryMeatFactory(class_1799 stack, int price, int count, int maxUses, int experience, float multiplier) {
            this.sell = stack;
            this.price = price;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        @Override
        public class_1914 create(class_1297 entity, Random random) {
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.price).method_7977((class_2561)new class_2588("text.moborigins.mystery_meat")), new class_1799((class_1935)this.sell.method_7909(), this.count), this.maxUses, this.experience, this.multiplier);
        }
    }

    static class EnchantBookFactory
    implements Factory {
        private final int experience;

        public EnchantBookFactory(int experience) {
            this.experience = experience;
        }

        @Override
        public class_1914 create(class_1297 entity, Random random) {
            List list = class_2378.field_11160.method_10220().filter(class_1887::method_25949).collect(Collectors.toList());
            class_1887 enchantment = (class_1887)list.get(random.nextInt(list.size()));
            int i = class_3532.method_15395((Random)random, (int)enchantment.method_8187(), (int)enchantment.method_8183());
            class_1799 itemStack = class_1772.method_7808((class_1889)new class_1889(enchantment, i));
            int j = 2 + random.nextInt(5 + i * 10) + 3 * i;
            if (enchantment.method_8193()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, j), new class_1799((class_1935)class_1802.field_8529), itemStack, 12, this.experience, 0.2f);
        }
    }
}

