/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.debug;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import net.minecraft.class_124;
import net.minecraft.class_340;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_340.class})
public abstract class MixinDebugHud {
    @Shadow
    private static long method_1838(long bytes) {
        throw new UnsupportedOperationException();
    }

    @Inject(method={"getRightText"}, at={@At(value="RETURN")})
    private void appendRightText(CallbackInfoReturnable<List<String>> cir) {
        List strings = (List)cir.getReturnValue();
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            if (!str.startsWith("Allocated:")) continue;
            strings.add(i + 1, MixinDebugHud.getNativeMemoryString());
            break;
        }
        strings.add("");
        strings.addAll(MixinDebugHud.getChunkRendererDebugStrings());
        if (SodiumClientMod.options().advanced.disableDriverBlacklist) {
            strings.add(class_124.field_1061 + "(!!) Driver blacklist ignored");
        }
    }

    private static List<String> getChunkRendererDebugStrings() {
        ChunkRenderBackend<?> backend = SodiumWorldRenderer.getInstance().getChunkRenderer();
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("Chunk Renderer: " + backend.getRendererName());
        strings.addAll(backend.getDebugStrings());
        return strings;
    }

    private static String getNativeMemoryString() {
        return "Off-Heap: +" + MixinDebugHud.method_1838(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed()) + "MB";
    }
}

