/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.beacons;

import dev.sapphic.beacons.BeaconTier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2580;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import org.jetbrains.annotations.Nullable;

public interface TieredBeacon {
    public BeaconTier getTier();

    public static int updateBaseAndTier(class_2580 beacon, class_1937 level, int x, int y, int z) {
        int oy;
        int levels = 0;
        boolean netherite = true;
        boolean diamond = true;
        int layer = 1;
        while (layer <= 4 && (oy = y - layer) >= 0) {
            boolean valid = true;
            block1: for (int ox = x - layer; ox <= x + layer && valid; ++ox) {
                for (int oz = z - layer; oz <= z + layer; ++oz) {
                    class_2680 state = level.method_8320(new class_2338(ox, oy, oz));
                    if (!state.method_26164((class_3494)class_3481.field_22275)) {
                        valid = false;
                        continue block1;
                    }
                    if (!state.method_27852(class_2246.field_22108)) {
                        netherite = false;
                    }
                    if (state.method_27852(class_2246.field_10201)) continue;
                    diamond = false;
                }
            }
            if (!valid) {
                if (layer > 1) {
                    BeaconTier.set(beacon, BeaconTier.of(diamond, netherite));
                }
                return levels;
            }
            levels = layer++;
        }
        BeaconTier.set(beacon, BeaconTier.of(diamond, netherite));
        return levels;
    }

    public static void applyTieredEffects(class_2580 beacon, class_1937 level, class_2338 pos, int levels, @Nullable class_1291 primary, @Nullable class_1291 secondary) {
        int tier;
        if (level.field_9236 || primary == null) {
            return;
        }
        int primaryAmplifier = tier = BeaconTier.get(beacon).ordinal();
        int secondaryAmplifier = tier;
        if (primary == class_1294.field_5925 || primary == class_1294.field_5918) {
            primaryAmplifier = 0;
        }
        if (secondary == class_1294.field_5906) {
            secondaryAmplifier = 0;
        }
        if (levels >= 4 && primary == secondary && primary != class_1294.field_5918) {
            primaryAmplifier = Math.min(primaryAmplifier, secondaryAmplifier);
            ++primaryAmplifier;
        }
        double radius = levels * 10 + 10 * (tier + 1);
        int duration = (9 * (tier + 1) + levels * 2) * 20;
        class_238 range = new class_238(pos).method_1014(radius).method_1012(0.0, (double)level.method_24853(), 0.0);
        boolean uniqueSecondary = levels >= 4 && primary != secondary && secondary != null;
        for (class_1657 player : level.method_18467(class_1657.class, range)) {
            player.method_6092(new class_1293(primary, duration, primaryAmplifier, true, true));
            if (!uniqueSecondary) continue;
            player.method_6092(new class_1293(secondary, duration, secondaryAmplifier, true, true));
        }
    }
}

