/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.common.util.collections;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.concurrent.locks.StampedLock;

public class DoubleBufferedLong2ObjectHashMap<V> {
    private final Long2ObjectMap<V> mapPending;
    private Long2ObjectMap<V> mapLocal;
    private Long2ObjectMap<V> mapShared;
    private final StampedLock lock = new StampedLock();

    public DoubleBufferedLong2ObjectHashMap() {
        this(16, 0.5f);
    }

    public DoubleBufferedLong2ObjectHashMap(int capacity, float loadFactor) {
        this.mapLocal = new Long2ObjectOpenHashMap(capacity, loadFactor);
        this.mapShared = new Long2ObjectOpenHashMap(capacity, loadFactor);
        this.mapPending = new Long2ObjectOpenHashMap(capacity, loadFactor);
    }

    public V getSync(long k) {
        return (V)this.mapLocal.get(k);
    }

    public V putSync(long k, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null, use enqueueRemoveSync instead to remove entries");
        }
        this.mapPending.put(k, value);
        return (V)this.mapLocal.put(k, value);
    }

    public V removeSync(long k) {
        this.mapPending.put(k, null);
        return (V)this.mapLocal.remove(k);
    }

    public boolean containsSync(long k) {
        return this.mapLocal.containsKey(k);
    }

    public V getAsync(long k) {
        long stamp;
        Object ret = null;
        do {
            stamp = this.lock.tryOptimisticRead();
            try {
                ret = this.mapShared.get(k);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        } while (!this.lock.validate(stamp));
        return (V)ret;
    }

    public void flushChangesSync() {
        if (this.mapPending.isEmpty()) {
            return;
        }
        this.swapTables();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.mapPending)) {
            long key = entry.getLongKey();
            Object val = entry.getValue();
            if (val == null) {
                this.mapLocal.remove(key);
                continue;
            }
            this.mapLocal.put(key, val);
        }
        this.mapPending.clear();
    }

    private void swapTables() {
        long writeLock = this.lock.writeLock();
        Long2ObjectMap<V> mapShared = this.mapLocal;
        Long2ObjectMap<V> mapLocal = this.mapShared;
        this.mapShared = mapShared;
        this.mapLocal = mapLocal;
        this.lock.unlockWrite(writeLock);
    }
}

