/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ModifyFoodPower;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.util.AttributeUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class})
public class HungerManagerMixin {
    @Unique
    private class_1657 player;

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/FoodComponent;getHunger()I"))
    private int modifyHunger(class_4174 foodComponent, class_1792 item, class_1799 stack) {
        if (this.player != null) {
            double baseValue = foodComponent.method_19230();
            List<class_1322> modifiers = ((OriginComponent)ModComponents.ORIGIN.get((Object)this.player)).getPowers(ModifyFoodPower.class).stream().filter(p -> p.doesApply(stack)).flatMap(p -> p.getFoodModifiers().stream()).collect(Collectors.toList());
            return (int)AttributeUtil.sortAndApplyModifiers(modifiers, baseValue);
        }
        return foodComponent.method_19230();
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/FoodComponent;getSaturationModifier()F"))
    private float modifySaturation(class_4174 foodComponent, class_1792 item, class_1799 stack) {
        if (this.player != null) {
            double baseValue = foodComponent.method_19231();
            List<class_1322> modifiers = ((OriginComponent)ModComponents.ORIGIN.get((Object)this.player)).getPowers(ModifyFoodPower.class).stream().filter(p -> p.doesApply(stack)).flatMap(p -> p.getSaturationModifiers().stream()).collect(Collectors.toList());
            return (float)AttributeUtil.sortAndApplyModifiers(modifiers, baseValue);
        }
        return foodComponent.method_19231();
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;add(IF)V", shift=At.Shift.AFTER)})
    private void executeAdditionalEatAction(class_1792 item, class_1799 stack, CallbackInfo ci) {
        if (this.player != null) {
            ((OriginComponent)ModComponents.ORIGIN.get((Object)this.player)).getPowers(ModifyFoodPower.class).stream().filter(p -> p.doesApply(stack)).forEach(ModifyFoodPower::eat);
        }
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void cachePlayer(class_1657 player, CallbackInfo ci) {
        this.player = player;
    }
}

