/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.AttackerActionWhenHitPower;
import io.github.apace100.origins.power.ClimbingPower;
import io.github.apace100.origins.power.EffectImmunityPower;
import io.github.apace100.origins.power.ModifyJumpPower;
import io.github.apace100.origins.power.ModifyLavaSpeedPower;
import io.github.apace100.origins.power.ModifySwimSpeedPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.PreventDeathPower;
import io.github.apace100.origins.power.SelfActionOnHitPower;
import io.github.apace100.origins.power.SelfActionOnKillPower;
import io.github.apace100.origins.power.SelfActionWhenHitPower;
import io.github.apace100.origins.power.SetEntityGroupPower;
import io.github.apace100.origins.power.SwimmingPower;
import io.github.apace100.origins.power.TargetActionOnHitPower;
import io.github.apace100.origins.power.WalkOnFluidPower;
import io.github.apace100.origins.registry.ModComponents;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    private Optional<class_2338> field_22418;
    @Unique
    private float cachedDamageAmount;

    @Shadow
    protected abstract float method_6106();

    @Shadow
    public abstract float method_6029();

    @Shadow
    public abstract boolean method_21754();

    @Shadow
    public abstract void method_6033(float var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"canWalkOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyWalkableFluids(class_3611 fluid, CallbackInfoReturnable<Boolean> info) {
        if (OriginComponent.getPowers(this, WalkOnFluidPower.class).stream().anyMatch(p -> fluid.method_15791(p.getFluidTag()))) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void invokeHitActions(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            OriginComponent.getPowers(this, SelfActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            OriginComponent.getPowers(this, AttackerActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            OriginComponent.getPowers(source.method_5529(), SelfActionOnHitPower.class).forEach(p -> p.onHit((class_1309)this, source, amount));
            OriginComponent.getPowers(source.method_5529(), TargetActionOnHitPower.class).forEach(p -> p.onHit((class_1309)this, source, amount));
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onDeath(Lnet/minecraft/entity/damage/DamageSource;)V")})
    private void invokeKillAction(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        OriginComponent.getPowers(source.method_5529(), SelfActionOnKillPower.class).forEach(p -> p.onKill((class_1309)this, source, amount));
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(doubleValue=0.5, ordinal=0), @Constant(doubleValue=0.5, ordinal=1), @Constant(doubleValue=0.5, ordinal=2)})
    private double modifyLavaSpeed(double original) {
        return OriginComponent.modify((class_1297)this, ModifyLavaSpeedPower.class, original);
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(class_1309 livingEntity) {
        if (OriginComponent.hasPower((class_1297)livingEntity, SwimmingPower.class) && livingEntity.method_5681() && !(this.method_5861((class_3494)class_3486.field_15517) > 0.0)) {
            return false;
        }
        return livingEntity.method_5637();
    }

    @Inject(at={@At(value="HEAD")}, method={"getGroup"}, cancellable=true)
    public void getGroup(CallbackInfoReturnable<class_1310> info) {
        OriginComponent component;
        List<SetEntityGroupPower> groups;
        if (this instanceof class_1657 && (groups = (component = (OriginComponent)ModComponents.ORIGIN.get((Object)this)).getPowers(SetEntityGroupPower.class)).size() > 0) {
            if (groups.size() > 1) {
                Origins.LOGGER.warn("Player " + this.method_5476().toString() + " has two instances of SetEntityGroupPower.");
            }
            info.setReturnValue((Object)groups.get((int)0).group);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getJumpVelocity"}, cancellable=true)
    private void modifyJumpVelocity(CallbackInfoReturnable<Float> info) {
        float base = 0.42f * this.method_23313();
        float modified = OriginComponent.modify(this, ModifyJumpPower.class, base, p -> {
            p.executeAction();
            return true;
        });
        info.setReturnValue((Object)Float.valueOf(modified));
    }

    @Inject(at={@At(value="HEAD")}, method={"canHaveStatusEffect"}, cancellable=true)
    private void preventStatusEffects(class_1293 effect, CallbackInfoReturnable<Boolean> info) {
        for (EffectImmunityPower power : OriginComponent.getPowers(this, EffectImmunityPower.class)) {
            if (!power.doesApply(effect)) continue;
            info.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isClimbing"}, cancellable=true)
    public void doSpiderClimbing(CallbackInfoReturnable<Boolean> info) {
        List<ClimbingPower> climbingPowers;
        if (!((Boolean)info.getReturnValue()).booleanValue() && this instanceof class_1657 && (climbingPowers = ((OriginComponent)ModComponents.ORIGIN.get((Object)this)).getPowers(ClimbingPower.class, true)).size() > 0) {
            if (climbingPowers.stream().anyMatch(Power::isActive)) {
                class_2338 pos = this.method_24515();
                this.field_22418 = Optional.of(pos);
                info.setReturnValue((Object)true);
            } else if (this.method_21754() && climbingPowers.stream().anyMatch(ClimbingPower::canHold)) {
                info.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBreatheInWater"}, cancellable=true)
    public void doWaterBreathing(CallbackInfoReturnable<Boolean> info) {
        if (PowerTypes.WATER_BREATHING.isActive(this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updateVelocity(FLnet/minecraft/util/math/Vec3d;)V", ordinal=0))
    public void modifyUnderwaterMovementSpeed(class_1309 livingEntity, float speedMultiplier, class_243 movementInput) {
        livingEntity.method_5724(OriginComponent.modify((class_1297)livingEntity, ModifySwimSpeedPower.class, speedMultiplier), movementInput);
    }

    @ModifyConstant(method={"swimUpward"}, constant={@Constant(doubleValue=0.03999999910593033)})
    public double modifyUpwardSwimming(double original) {
        return OriginComponent.modify((class_1297)this, ModifySwimSpeedPower.class, original);
    }

    @ModifyConstant(method={"knockDownwards"}, constant={@Constant(doubleValue=-0.03999999910593033)})
    @Environment(value=EnvType.CLIENT)
    public double swimDown(double original) {
        return OriginComponent.modify((class_1297)this, ModifySwimSpeedPower.class, original);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;method_26317(DZLnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"))
    public class_243 method_26317Proxy(class_1309 entity, double d, boolean bl, class_243 vec3d) {
        class_243 oldReturn = entity.method_26317(d, bl, vec3d);
        if (PowerTypes.LIKE_WATER.isActive(this) && Math.abs(vec3d.field_1351 - d / 16.0) < 0.025) {
            return new class_243(oldReturn.field_1352, 0.0, oldReturn.field_1350);
        }
        return entity.method_26317(d, bl, vec3d);
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"), method={"travel"}, name={"d"}, ordinal=0)
    public double doAvianSlowFalling(double in) {
        if (PowerTypes.SLOW_FALLING.isActive(this)) {
            this.field_6017 = 0.0f;
            if (this.method_18798().field_1351 <= 0.0) {
                return 0.01;
            }
        }
        return in;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z")})
    private void cacheDamageAmount(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.cachedDamageAmount = amount;
    }

    @Inject(method={"tryUseTotem"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Hand;values()[Lnet/minecraft/util/Hand;")}, cancellable=true)
    private void preventDeath(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        Optional<PreventDeathPower> preventDeathPower = OriginComponent.getPowers(this, PreventDeathPower.class).stream().filter(p -> p.doesApply(source, this.cachedDamageAmount)).findFirst();
        if (preventDeathPower.isPresent()) {
            this.method_6033(1.0f);
            preventDeathPower.get().executeAction();
            cir.setReturnValue((Object)true);
        }
    }
}

