/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.AttributedEntityAttributeModifier;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1324;
import net.minecraft.class_1657;

public class ConditionedAttributePower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final int tickRate;

    public ConditionedAttributePower(PowerType<?> type, class_1657 player, int tickRate) {
        super(type, player);
        this.setTicking(true);
        this.tickRate = tickRate;
    }

    @Override
    public void tick() {
        if (this.player.field_6012 % this.tickRate == 0) {
            if (this.isActive()) {
                this.addMods();
            } else {
                this.removeMods();
            }
        }
    }

    @Override
    public void onRemoved() {
        this.removeMods();
    }

    public ConditionedAttributePower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public void addMods() {
        this.modifiers.forEach(mod -> {
            class_1324 instance;
            if (this.player.method_6127().method_27306(mod.getAttribute()) && (instance = this.player.method_5996(mod.getAttribute())) != null && !instance.method_6196(mod.getModifier())) {
                instance.method_26835(mod.getModifier());
            }
        });
    }

    public void removeMods() {
        this.modifiers.forEach(mod -> {
            class_1324 instance;
            if (this.player.method_6127().method_27306(mod.getAttribute()) && (instance = this.player.method_5996(mod.getAttribute())) != null && instance.method_6196(mod.getModifier())) {
                instance.method_6202(mod.getModifier());
            }
        });
    }
}

