/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.collections;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2593;

public class BlockEntityList
implements List<class_2586> {
    private final ReferenceLinkedOpenHashSet<class_2586> allBlockEntities;
    private final Long2ReferenceOpenHashMap<class_2586> posMap;
    private final Long2ReferenceOpenHashMap<List<class_2586>> posMapMulti;

    public BlockEntityList(List<class_2586> list, boolean hasPositionLookup) {
        this.posMap = hasPositionLookup ? new Long2ReferenceOpenHashMap() : null;
        Long2ReferenceOpenHashMap long2ReferenceOpenHashMap = this.posMapMulti = hasPositionLookup ? new Long2ReferenceOpenHashMap() : null;
        if (this.posMap != null) {
            this.posMap.defaultReturnValue(null);
            this.posMapMulti.defaultReturnValue(null);
        }
        this.allBlockEntities = new ReferenceLinkedOpenHashSet();
        this.addAll((Collection<? extends class_2586>)list);
    }

    @Override
    public int size() {
        return this.allBlockEntities.size();
    }

    @Override
    public boolean isEmpty() {
        return this.allBlockEntities.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.allBlockEntities.contains(o);
    }

    @Override
    public Iterator<class_2586> iterator() {
        return this.allBlockEntities.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.allBlockEntities.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.allBlockEntities.toArray((Object[])a);
    }

    @Override
    public boolean add(class_2586 blockEntity) {
        return this.addNoDoubleAdd(blockEntity, true);
    }

    private boolean addNoDoubleAdd(class_2586 blockEntity, boolean exceptionOnDoubleAdd) {
        long pos;
        class_2586 prev;
        boolean added = this.allBlockEntities.add((Object)blockEntity);
        if (!added && exceptionOnDoubleAdd && !(blockEntity instanceof class_2593)) {
            this.throwException(blockEntity);
        }
        if (added && this.posMap != null && (prev = (class_2586)this.posMap.putIfAbsent(pos = BlockEntityList.getEntityPos(blockEntity), (Object)blockEntity)) != null) {
            List multiEntry = (List)this.posMapMulti.computeIfAbsent(pos, l -> new ArrayList());
            if (multiEntry.size() == 0) {
                multiEntry.add(prev);
            }
            multiEntry.add(blockEntity);
        }
        return added;
    }

    private void throwException(class_2586 blockEntity) {
        throw new IllegalStateException("Lithium BlockEntityList" + (this.posMap != null ? " with posMap" : "") + ": Adding the same BlockEntity object twice: " + blockEntity.method_11007(new class_2487()));
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof class_2586) {
            class_2586 blockEntity = (class_2586)o;
            if (this.allBlockEntities.remove(o)) {
                if (this.posMap != null) {
                    long pos = BlockEntityList.getEntityPos(blockEntity);
                    List multiEntry = (List)this.posMapMulti.get(pos);
                    if (multiEntry != null) {
                        multiEntry.remove(blockEntity);
                        if (multiEntry.size() <= 1) {
                            this.posMapMulti.remove(pos);
                        }
                    }
                    if (multiEntry != null && multiEntry.size() > 0) {
                        this.posMap.put(pos, multiEntry.get(0));
                    } else {
                        this.posMap.remove(pos);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.allBlockEntities.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends class_2586> c) {
        for (class_2586 class_25862 : c) {
            this.add(class_25862);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends class_2586> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object obj : c) {
            modified |= this.remove(obj);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (class_2586 blockEntity : this.allBlockEntities) {
            if (c.contains(blockEntity)) continue;
            modified |= this.remove(blockEntity);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.allBlockEntities.clear();
        if (this.posMap != null) {
            this.posMap.clear();
            this.posMapMulti.clear();
        }
    }

    @Override
    public class_2586 get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public class_2586 set(int index, class_2586 element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, class_2586 element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public class_2586 remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<class_2586> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<class_2586> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<class_2586> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private static long getEntityPos(class_2586 e) {
        return e.method_11016().method_10063();
    }

    public boolean addIfAbsent(class_2586 blockEntity) {
        return this.addNoDoubleAdd(blockEntity, false);
    }

    public boolean hasPositionLookup() {
        return this.posMap != null;
    }

    public void markRemovedAndRemoveAllAtPosition(class_2338 blockPos) {
        long pos = blockPos.method_10063();
        class_2586 blockEntity = (class_2586)this.posMap.remove(pos);
        if (blockEntity != null) {
            List multiEntry = (List)this.posMapMulti.remove(pos);
            if (multiEntry != null) {
                for (class_2586 blockEntity1 : multiEntry) {
                    blockEntity1.method_11012();
                    this.allBlockEntities.remove((Object)blockEntity1);
                }
            } else {
                blockEntity.method_11012();
                this.allBlockEntities.remove((Object)blockEntity);
            }
        }
    }

    public class_2586 getFirstNonRemovedBlockEntityAtPosition(long pos) {
        if (this.isEmpty()) {
            return null;
        }
        class_2586 blockEntity = (class_2586)this.posMap.get(pos);
        if (blockEntity == null || !blockEntity.method_11015()) {
            return blockEntity;
        }
        List multiEntry = (List)this.posMapMulti.get(pos);
        if (multiEntry != null) {
            for (class_2586 blockEntity1 : multiEntry) {
                if (blockEntity1.method_11015()) continue;
                return blockEntity1;
            }
        }
        return null;
    }
}

