/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.mixin.lightsource;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsMode;
import me.lambdaurora.lambdynlights.LambDynLights;
import me.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements DynamicLightSource {
    @Shadow
    public class_1937 field_6002;
    @Shadow
    public boolean field_5988;
    @Shadow
    public int field_6024;
    @Shadow
    public int field_5980;
    private int lambdynlights_luminance = 0;
    private int lambdynlights_lastLuminance = 0;
    private long lambdynlights_lastUpdate = 0L;
    private double lambdynlights_prevX;
    private double lambdynlights_prevY;
    private double lambdynlights_prevZ;
    private LongOpenHashSet trackedLitChunkPos = new LongOpenHashSet();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract double method_23320();

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract boolean method_5809();

    @Shadow
    public abstract class_1299<?> method_5864();

    @Shadow
    public abstract class_2338 method_24515();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.field_6002.method_8608()) {
            if (this.field_5988) {
                this.setDynamicLightEnabled(false);
            } else {
                this.dynamicLightTick();
                if (!LambDynLights.get().config.hasEntitiesLightSource() && this.method_5864() != class_1299.field_6097) {
                    this.lambdynlights_luminance = 0;
                }
                LambDynLights.updateTracking(this);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    public void onRemove(CallbackInfo ci) {
        if (this.field_6002.method_8608()) {
            this.setDynamicLightEnabled(false);
        }
    }

    @Override
    public double getDynamicLightX() {
        return this.method_23317();
    }

    @Override
    public double getDynamicLightY() {
        return this.method_23320();
    }

    @Override
    public double getDynamicLightZ() {
        return this.method_23321();
    }

    @Override
    public class_1937 getDynamicLightWorld() {
        return this.field_6002;
    }

    @Override
    public void resetDynamicLight() {
        this.lambdynlights_lastLuminance = 0;
    }

    @Override
    public boolean shouldUpdateDynamicLight() {
        DynamicLightsMode mode = LambDynLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lambdynlights_lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lambdynlights_lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public void dynamicLightTick() {
        this.lambdynlights_luminance = this.method_5809() ? 15 : 0;
        int luminance = DynamicLightHandlers.getLuminanceFrom((class_1297)this);
        if (luminance > this.lambdynlights_luminance) {
            this.lambdynlights_luminance = luminance;
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights_luminance;
    }

    @Override
    public boolean lambdynlights_updateDynamicLight(@NotNull class_761 renderer) {
        if (!this.shouldUpdateDynamicLight()) {
            return false;
        }
        double deltaX = this.method_23317() - this.lambdynlights_prevX;
        double deltaY = this.method_23318() - this.lambdynlights_prevY;
        double deltaZ = this.method_23321() - this.lambdynlights_prevZ;
        int luminance = this.getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.lambdynlights_lastLuminance) {
            this.lambdynlights_prevX = this.method_23317();
            this.lambdynlights_prevY = this.method_23318();
            this.lambdynlights_prevZ = this.method_23321();
            this.lambdynlights_lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                class_2338.class_2339 chunkPos = new class_2338.class_2339(this.field_6024, class_3532.method_15346((int)((int)this.method_23320()), (int)16), this.field_5980);
                LambDynLights.scheduleChunkRebuild(renderer, (class_2338)chunkPos);
                LambDynLights.updateTrackedChunks((class_2338)chunkPos, this.trackedLitChunkPos, newPos);
                class_2350 directionX = (this.method_24515().method_10263() & 0xF) >= 8 ? class_2350.field_11034 : class_2350.field_11039;
                class_2350 directionY = (class_3532.method_15365((double)this.method_23320()) & 0xF) >= 8 ? class_2350.field_11036 : class_2350.field_11033;
                class_2350 directionZ = (this.method_24515().method_10260() & 0xF) >= 8 ? class_2350.field_11035 : class_2350.field_11043;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.method_10098(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.method_10098(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.method_10098(directionX.method_10153());
                    } else {
                        chunkPos.method_10098(directionZ.method_10153());
                        chunkPos.method_10098(directionY);
                    }
                    LambDynLights.scheduleChunkRebuild(renderer, (class_2338)chunkPos);
                    LambDynLights.updateTrackedChunks((class_2338)chunkPos, this.trackedLitChunkPos, newPos);
                }
            }
            this.lambdynlights_scheduleTrackedChunksRebuild(renderer);
            this.trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void lambdynlights_scheduleTrackedChunksRebuild(@NotNull class_761 renderer) {
        if (class_310.method_1551().field_1687 == this.field_6002) {
            LongIterator longIterator = this.trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

