/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.client;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.mixin.client.contributorcapes.AbstractClientPlayerEntityMixin;
import com.therandomlabs.randompatches.mixin.client.contributorcapes.PlayerListEntryMixin;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_640;
import net.minecraft.class_742;
import org.apache.commons.io.IOUtils;

@Environment(value=EnvType.CLIENT)
public final class RPContributorCapeHandler {
    private static final URI CONTRIBUTORS = URI.create("https://raw.githubusercontent.com/TheRandomLabs/RandomPatches/misc/contributors.txt");
    private static final class_2960 CAPE = new class_2960("randompatches", "textures/contributor_cape.png");
    private static final Set<UUID> temporaryPlayerInfos = new HashSet<UUID>();
    private static final List<String> contributors = new ArrayList<String>();
    private static boolean attemptingDownload;
    private static int tries;

    private RPContributorCapeHandler() {
    }

    public static void onPreRenderPlayer(class_742 player) {
        if (!RandomPatches.config().client.contributorCapes()) {
            return;
        }
        if (contributors.isEmpty()) {
            RPContributorCapeHandler.downloadContributorList();
            return;
        }
        if (!FabricLoader.getInstance().isDevelopmentEnvironment() && !contributors.contains(player.method_5845())) {
            return;
        }
        AbstractClientPlayerEntityMixin accessor = (AbstractClientPlayerEntityMixin)player;
        if (accessor.invokeGetPlayerListEntry() == null) {
            accessor.setCachedScoreboardEntry(new class_640(new class_2703.class_2705(new class_2703(), player.method_7334(), 0, null, null)));
            temporaryPlayerInfos.add(player.method_5667());
        }
        Map<MinecraftProfileTexture.Type, class_2960> textures = ((PlayerListEntryMixin)accessor.invokeGetPlayerListEntry()).getTextures();
        textures.putIfAbsent(MinecraftProfileTexture.Type.CAPE, CAPE);
        textures.putIfAbsent(MinecraftProfileTexture.Type.ELYTRA, CAPE);
    }

    public static void onPostRenderPlayer(class_742 player) {
        UUID uniqueID = player.method_5667();
        if (temporaryPlayerInfos.contains(uniqueID)) {
            ((AbstractClientPlayerEntityMixin)player).setCachedScoreboardEntry(null);
            temporaryPlayerInfos.remove(uniqueID);
        }
    }

    public static void downloadContributorList() {
        if (attemptingDownload || tries > 5) {
            return;
        }
        attemptingDownload = true;
        new Thread(() -> {
            try {
                contributors.clear();
                contributors.addAll(IOUtils.readLines((Reader)new StringReader(IOUtils.toString((URI)CONTRIBUTORS, (Charset)StandardCharsets.UTF_8))));
            }
            catch (IOException ex) {
                RandomPatches.logger.error("Failed to download contributor list", (Throwable)ex);
                ++tries;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex2) {
                    RandomPatches.logger.error("Failed to sleep", (Throwable)ex2);
                }
            }
            attemptingDownload = false;
        }).start();
    }
}

