/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2861;
import ru.bclib.api.WorldDataAPI;

public class DataFixerAPI {
    private static final Map<String, String> REPLACEMENT = Maps.newHashMap();
    private static final Map<String, Integer> FIX_VERSIONS = Maps.newHashMap();

    public static void fixData(File dir) {
        REPLACEMENT.clear();
        if (REPLACEMENT.isEmpty()) {
            return;
        }
        boolean shoudFix = false;
        Collection mods = FabricLoader.getInstance().getAllMods();
        for (ModContainer mod : mods) {
            String name = mod.getMetadata().getId();
            int preVersion = WorldDataAPI.getIntModVersion(name);
            int version = DataFixerAPI.getModVersion(mod.getMetadata().getVersion().toString());
            if (version <= preVersion) continue;
            int fixVersion = FIX_VERSIONS.getOrDefault(name, version);
            shoudFix |= fixVersion < version && fixVersion >= preVersion;
        }
        if (!shoudFix) {
            return;
        }
        List<File> regions = DataFixerAPI.getAllRegions(dir, null);
        regions.parallelStream().forEach(file -> {
            try {
                System.out.println("Fixing " + file);
                boolean[] changed = new boolean[1];
                class_2861 region = new class_2861(file, file.getParentFile(), true);
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        class_1923 pos = new class_1923(x, z);
                        changed[0] = false;
                        if (!region.method_12423(pos)) continue;
                        DataInputStream input = region.method_21873(pos);
                        class_2487 root = class_2507.method_10627((DataInput)input);
                        input.close();
                        class_2499 sections = root.method_10562("Level").method_10554("Sections", 10);
                        sections.forEach(tag -> {
                            class_2499 palette = ((class_2487)tag).method_10554("Palette", 10);
                            palette.forEach(blockTag -> {
                                class_2487 blockTagCompound = (class_2487)blockTag;
                                String name = blockTagCompound.method_10558("Name");
                                String replace = REPLACEMENT.get(name);
                                if (replace != null) {
                                    blockTagCompound.method_10582("Name", replace);
                                    changed[0] = true;
                                }
                            });
                        });
                        if (!changed[0]) continue;
                        System.out.println("Write!");
                        DataOutputStream output = region.method_21881(pos);
                        class_2507.method_10628((class_2487)root, (DataOutput)output);
                        output.close();
                    }
                }
                region.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    protected static void addFix(String modID, String modVersion, String result, String ... names) {
        FIX_VERSIONS.put(modID, DataFixerAPI.getModVersion(modVersion));
        for (String name : names) {
            REPLACEMENT.put(name, result);
        }
    }

    private static List<File> getAllRegions(File dir, List<File> list) {
        if (list == null) {
            list = Lists.newArrayList();
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                DataFixerAPI.getAllRegions(file, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".mca")) continue;
            list.add(file);
        }
        return list;
    }

    public static int getModVersion(String version) {
        if (version.isEmpty()) {
            return 0;
        }
        try {
            String[] values = version.split("\\.");
            return Integer.parseInt(values[0]) << 12 | Integer.parseInt(values[1]) << 6 | Integer.parseInt(values[2]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getModVersion(int version) {
        int a = version >> 12 & 0x3F;
        int b = version >> 6 & 0x3F;
        int c = version & 0x3F;
        return String.format(Locale.ROOT, "%d.%d.%d", a, b, c);
    }
}

