/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.crafting;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import zabi.minecraft.extraalchemy.config.ModConfig;
import zabi.minecraft.extraalchemy.crafting.CraftingRecipes;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.utils.Log;

public class AlternativePotionRingRecipe
extends class_1852 {
    private int cost;
    private int length;
    private int renew;
    private int level;
    private class_1291 effect;

    public AlternativePotionRingRecipe(class_2960 id, int cost, int length, int level, int renew, class_1291 potion) {
        super(id);
        this.cost = cost;
        this.length = length;
        this.effect = potion;
        this.renew = renew;
        this.level = level;
    }

    public boolean matches(class_1715 inv, class_1937 world) {
        if (!ModConfig.INSTANCE.enableRings) {
            return false;
        }
        boolean foundEffect = false;
        boolean foundRing = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 is = inv.method_5438(i);
            class_1792 s = is.method_7909();
            if (s.equals(class_1802.field_8574)) {
                if (foundEffect || !this.doesPotionMatch(class_1844.method_8067((class_1799)is))) {
                    return false;
                }
                foundEffect = true;
                continue;
            }
            if (s.equals((Object)ModItems.EMPTY_RING)) {
                if (foundRing) {
                    return false;
                }
                foundRing = true;
                continue;
            }
            if (s.equals(class_1802.field_8162)) continue;
            return false;
        }
        return foundRing && foundEffect;
    }

    public class_1799 craft(class_1715 inv) {
        class_1799 result = new class_1799((class_1935)ModItems.POTION_RING);
        class_1844.method_8056((class_1799)result, Collections.singleton(new class_1293(this.effect)));
        result.method_7948();
        result.method_7969().method_10569("cost", this.cost);
        result.method_7969().method_10569("length", this.length);
        result.method_7969().method_10569("renew", this.renew);
        result.method_7969().method_10569("level", this.level);
        result.method_7969().method_10556("disabled", true);
        return result;
    }

    public class_1799 method_8110() {
        return this.craft(null);
    }

    public boolean method_8113(int width, int height) {
        return width > 1 || height > 1;
    }

    public class_1865<?> method_8119() {
        return CraftingRecipes.RING_CRAFTING_SERIALIZER;
    }

    private boolean doesPotionMatch(List<class_1293> stack) {
        if (stack.size() != 1) {
            return false;
        }
        class_1293 stackInstance = stack.get(0);
        return stackInstance.method_5579().equals(this.effect) && stackInstance.method_5578() == this.level;
    }

    public static class Serializer
    implements class_1865<AlternativePotionRingRecipe> {
        public AlternativePotionRingRecipe read(class_2960 id, JsonObject json) {
            int cost = json.get("cost").getAsInt();
            int length = json.get("length").getAsInt();
            int level = json.get("level").getAsInt();
            int renewTime = json.has("renew") ? json.get("renew").getAsInt() : 1;
            String effect_name = json.get("effect").getAsString();
            class_1291 effect = (class_1291)class_2378.field_11159.method_10223(new class_2960(effect_name));
            if (effect.method_5561()) {
                Log.w("The ring recipe %s has an instant effect associated with %s, this functionality is meant for long lasting effects.", id, effect_name);
            }
            return new AlternativePotionRingRecipe(id, cost, length, level, renewTime, effect);
        }

        public AlternativePotionRingRecipe read(class_2960 id, class_2540 buf) {
            int cost = buf.readInt();
            int length = buf.readInt();
            int renew = buf.readInt();
            int level = buf.readInt();
            String potion_name = buf.method_19772();
            class_1291 pot = (class_1291)class_2378.field_11159.method_10223(new class_2960(potion_name));
            return new AlternativePotionRingRecipe(id, cost, length, level, renew, pot);
        }

        public void write(class_2540 buf, AlternativePotionRingRecipe recipe) {
            buf.writeInt(recipe.cost);
            buf.writeInt(recipe.length);
            buf.writeInt(recipe.renew);
            buf.writeInt(recipe.level);
            buf.method_10814(class_2378.field_11159.method_10221((Object)recipe.effect).toString());
        }
    }
}

