/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.utils;

import net.minecraft.class_1657;
import zabi.minecraft.extraalchemy.utils.Log;

public class PlayerLevelUtil {
    private static final int MAX_LEVEL = 21862;
    private static final int[] xpmap = new int[21863];

    public static int getExperienceForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level > 21862) {
            return Integer.MAX_VALUE;
        }
        return xpmap[level];
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getLevelForExperience(int experience) {
        for (int i = 1; i < xpmap.length; ++i) {
            if (xpmap[i] <= experience) continue;
            return i - 1;
        }
        return xpmap.length;
    }

    public static int getPlayerXP(class_1657 player) {
        return (int)((float)PlayerLevelUtil.getExperienceForLevel(player.field_7520) + player.field_7510 * (float)player.method_7349());
    }

    public static void addPlayerXP(class_1657 player, int amount) {
        int experience;
        player.field_7495 = experience = Math.max(0, PlayerLevelUtil.getPlayerXP(player) + amount);
        player.field_7520 = PlayerLevelUtil.getLevelForExperience(experience);
        int expForLevel = PlayerLevelUtil.getExperienceForLevel(player.field_7520);
        player.field_7510 = (float)(experience - expForLevel) / (float)PlayerLevelUtil.getXpBarCapacity(player.field_7520);
    }

    static {
        int res = 0;
        for (int i = 0; i <= 21862; ++i) {
            if (res < 0) {
                res = Integer.MAX_VALUE;
                Log.e("Internal XP calculation is wrong. Level " + i + " already maxes out.");
            }
            PlayerLevelUtil.xpmap[i] = res;
            res += PlayerLevelUtil.getXpBarCapacity(i);
        }
    }
}

