/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class ScaleUtils {
    public static final float DEFAULT_MINIMUM_POSITIVE_SCALE = 1.2621775E-29f;
    public static final float DEFAULT_MAXIMUM_POSITIVE_SCALE = 4.2949673E9f;
    private static final float MINIMUM_LIMB_MOTION_SCALE = 1.2621775E-29f;

    public static void tickScale(ScaleData data) {
        ScaleType type = data.getScaleType();
        ((ScaleEventCallback)type.getPreTickEvent().invoker()).onEvent(data);
        data.tick();
        ((ScaleEventCallback)type.getPostTickEvent().invoker()).onEvent(data);
    }

    public static void loadAverageScales(class_1297 target, class_1297 source, class_1297 ... sources) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleData scaleData = type.getScaleData(target);
            ScaleData[] scales = new ScaleData[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                scales[i] = type.getScaleData(sources[i]);
            }
            scaleData.averagedFromScales(type.getScaleData(source), scales);
        }
    }

    public static void loadScaleOnRespawn(class_1297 target, class_1297 source, boolean alive) {
        if (alive || PehkuiConfig.COMMON.keepAllScalesOnRespawn.get().booleanValue()) {
            ScaleUtils.loadScale(target, source);
            return;
        }
        List<String> keptScales = PehkuiConfig.COMMON.scalesKeptOnRespawn.get();
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            if (!keptScales.contains(((class_2960)entry.getKey()).toString())) continue;
            ScaleType type = (ScaleType)entry.getValue();
            type.getScaleData(target).fromScale(type.getScaleData(source));
        }
    }

    public static void loadScale(class_1297 target, class_1297 source) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            type.getScaleData(target).fromScale(type.getScaleData(source));
        }
    }

    public static boolean isAboveCollisionThreshold(class_1297 entity) {
        double scaleThreshold;
        double threshold;
        float heightScale;
        float widthScale = ScaleUtils.getWidthScale(entity);
        double volume = widthScale * widthScale * (heightScale = ScaleUtils.getHeightScale(entity));
        return volume > (threshold = (scaleThreshold = PehkuiConfig.COMMON.largeScaleCollisionThreshold.get().doubleValue()) * scaleThreshold * scaleThreshold);
    }

    public static float modifyLimbDistance(float value, class_1297 entity) {
        float scale = ScaleUtils.getMotionScale(entity);
        if (scale == 1.0f) {
            return value;
        }
        float ret = value / scale;
        if (ret > 1.2621775E-29f || ret < -1.2621775E-29f) {
            return ret;
        }
        return ret < 0.0f ? -1.2621775E-29f : 1.2621775E-29f;
    }

    public static final float modifyProjectionMatrixDepthByWidth(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleUtils.modifyProjectionMatrixDepth(ScaleUtils.getWidthScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepthByHeight(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleUtils.modifyProjectionMatrixDepth(ScaleUtils.getHeightScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleUtils.modifyProjectionMatrixDepth(Math.min(ScaleUtils.getWidthScale(entity, tickDelta), ScaleUtils.getHeightScale(entity, tickDelta)), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float scale, float depth, class_1297 entity, float tickDelta) {
        if (scale < 1.0f) {
            return Math.max((float)PehkuiConfig.CLIENT.minimumCameraDepth.get().doubleValue(), depth * scale);
        }
        return depth;
    }

    public static float setScaleOfDrop(class_1297 entity, class_1297 source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getDropScale(source));
    }

    public static float setScaleOfProjectile(class_1297 entity, class_1297 source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getProjectileScale(source));
    }

    public static float setScaleOnSpawn(class_1297 entity, float scale) {
        if (scale != 1.0f) {
            ScaleType.BASE.getScaleData(entity).setScale(scale);
        }
        return scale;
    }

    public static class_2487 buildScaleNbtFromPacketByteBuf(class_2540 buffer) {
        class_2487 scaleData = new class_2487();
        float scale = buffer.readFloat();
        float prevScale = buffer.readFloat();
        float fromScale = buffer.readFloat();
        float toScale = buffer.readFloat();
        int scaleTicks = buffer.readInt();
        int totalScaleTicks = buffer.readInt();
        scaleData.method_10548("scale", scale);
        scaleData.method_10548("previous", prevScale);
        scaleData.method_10548("initial", fromScale);
        scaleData.method_10548("target", toScale);
        scaleData.method_10569("ticks", scaleTicks);
        scaleData.method_10569("total_ticks", totalScaleTicks);
        int baseModifierCount = buffer.readInt();
        if (baseModifierCount != 0) {
            class_2499 modifiers = new class_2499();
            for (int i = 0; i < baseModifierCount; ++i) {
                modifiers.add((Object)class_2509.field_11560.method_10639(buffer.method_10800(Short.MAX_VALUE)));
            }
            scaleData.method_10566("baseValueModifiers", (class_2520)modifiers);
        }
        return scaleData;
    }

    public static void syncScalesIfNeeded(class_1297 entity, Consumer<class_2596<?>> packetSender) {
        ScaleUtils.syncScales(entity, packetSender, ScaleData::shouldSync, true);
    }

    public static void syncScalesOnTrackingStart(class_1297 entity, Consumer<class_2596<?>> packetSender) {
        ScaleUtils.syncScales(entity, packetSender, s -> !s.isReset(), false);
    }

    public static void syncScales(class_1297 entity, Consumer<class_2596<?>> packetSender, Predicate<ScaleData> condition, boolean unmark) {
        int id = entity.method_5628();
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            ScaleData scaleData = ((ScaleType)entry.getValue()).getScaleData(entity);
            if (!condition.test(scaleData)) continue;
            packetSender.accept((class_2596<?>)new class_2658(Pehkui.SCALE_PACKET, scaleData.toPacket(new class_2540(Unpooled.buffer()).method_10804(id).method_10812((class_2960)entry.getKey()))));
            if (!unmark) continue;
            scaleData.markForSync(false);
        }
    }

    public static float getWidthScale(class_1297 entity) {
        return ScaleUtils.getWidthScale(entity, 1.0f);
    }

    public static float getWidthScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleType.WIDTH, tickDelta);
    }

    public static float getHeightScale(class_1297 entity) {
        return ScaleUtils.getHeightScale(entity, 1.0f);
    }

    public static float getHeightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleType.HEIGHT, tickDelta);
    }

    public static float getMotionScale(class_1297 entity) {
        return ScaleUtils.getMotionScale(entity, 1.0f);
    }

    public static float getMotionScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.MOTION, PehkuiConfig.COMMON.scaledMotion::get, tickDelta);
    }

    public static float getReachScale(class_1297 entity) {
        return ScaleUtils.getReachScale(entity, 1.0f);
    }

    public static float getReachScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.REACH, PehkuiConfig.COMMON.scaledReach::get, tickDelta);
    }

    public static float getAttackScale(class_1297 entity) {
        return ScaleUtils.getAttackScale(entity, 1.0f);
    }

    public static float getAttackScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.ATTACK, PehkuiConfig.COMMON.scaledAttack::get, tickDelta);
    }

    public static float getDefenseScale(class_1297 entity) {
        return ScaleUtils.getDefenseScale(entity, 1.0f);
    }

    public static float getDefenseScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.DEFENSE, PehkuiConfig.COMMON.scaledDefense::get, tickDelta);
    }

    public static float getHealthScale(class_1297 entity) {
        return ScaleUtils.getHealthScale(entity, 1.0f);
    }

    public static float getHealthScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.HEALTH, PehkuiConfig.COMMON.scaledHealth::get, tickDelta);
    }

    public static float getDropScale(class_1297 entity) {
        return ScaleUtils.getDropScale(entity, 1.0f);
    }

    public static float getDropScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.DROPS, PehkuiConfig.COMMON.scaledItemDrops::get, tickDelta);
    }

    public static float getProjectileScale(class_1297 entity) {
        return ScaleUtils.getProjectileScale(entity, 1.0f);
    }

    public static float getProjectileScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.PROJECTILES, PehkuiConfig.COMMON.scaledProjectiles::get, tickDelta);
    }

    public static float getExplosionScale(class_1297 entity) {
        return ScaleUtils.getExplosionScale(entity, 1.0f);
    }

    public static float getExplosionScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.EXPLOSIONS, PehkuiConfig.COMMON.scaledExplosions::get, tickDelta);
    }

    public static float getConfigurableTypedScale(class_1297 entity, ScaleType type, Supplier<Boolean> config, float tickDelta) {
        return config.get() != false ? ScaleUtils.getTypedScale(entity, type, tickDelta) : type.getDefaultBaseScale();
    }

    public static float getTypedScale(class_1297 entity, ScaleType type, float tickDelta) {
        return entity == null ? type.getDefaultBaseScale() : type.getScaleData(entity).getScale(tickDelta);
    }
}

