/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPModMainClient;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.CrossPortalViewRendering;
import qouteall.imm_ptl.core.render.GuiPortalRendering;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.Helper;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer
implements IEGameRenderer {
    @Shadow
    @Final
    @Mutable
    private LightTexture f_109074_;
    @Shadow
    private boolean f_109070_;
    @Shadow
    @Final
    @Mutable
    private Camera f_109054_;
    @Shadow
    @Final
    private Minecraft f_109059_;
    @Shadow
    private int f_109065_;
    @Shadow
    private boolean f_109076_;
    private static boolean portal_isRenderingHand = false;

    @Shadow
    public abstract void m_109111_(Matrix4f var1);

    @Shadow
    protected abstract void m_109138_(PoseStack var1, float var2);

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at={@At(value="HEAD")})
    private void onFarBeforeRendering(float tickDelta, long nanoTime, boolean renderWorldIn, CallbackInfo ci) {
        this.f_109059_.m_91307_().m_6180_("ip_pre_total_render");
        IPGlobal.preTotalRenderTaskList.processTasks();
        this.f_109059_.m_91307_().m_7238_();
        if (this.f_109059_.f_91073_ == null) {
            return;
        }
        this.f_109059_.m_91307_().m_6180_("ip_pre_render");
        RenderStates.updatePreRenderInfo(tickDelta);
        StableClientTimer.update(this.f_109059_.f_91073_.m_46467_(), tickDelta);
        ClientPortalAnimationManagement.update();
        IPCGlobal.clientTeleportationManager.manageTeleportation();
        IPGlobal.preGameRenderSignal.emit();
        if (IPCGlobal.earlyRemoteUpload) {
            MyRenderHelper.earlyRemoteUpload();
        }
        this.f_109059_.m_91307_().m_7238_();
        ++RenderStates.frameIndex;
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V")})
    private void onBeforeRenderingCenter(float float_1, long long_1, boolean boolean_1, CallbackInfo ci) {
        IPModMainClient.switchToCorrectRenderer();
        IPCGlobal.renderer.prepareRendering();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingCenter(float float_1, long long_1, boolean boolean_1, CallbackInfo ci) {
        IPCGlobal.renderer.finishRendering();
        RenderStates.onTotalRenderEnd();
        GuiPortalRendering.onGameRenderEnd();
        if (IPCGlobal.lateClientLightUpdate) {
            this.f_109059_.m_91307_().m_6180_("ip_late_update_light");
            MyRenderHelper.lateUpdateLight();
            this.f_109059_.m_91307_().m_7238_();
        }
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"))
    private void redirectRenderingWorld(GameRenderer gameRenderer, float tickDelta, long limitTime, PoseStack matrix) {
        if (CrossPortalViewRendering.renderCrossPortalView()) {
            return;
        }
        gameRenderer.m_109089_(tickDelta, limitTime, matrix);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="TAIL")})
    private void onRenderCenterEnded(float float_1, long long_1, PoseStack matrixStack_1, CallbackInfo ci) {
        IPCGlobal.renderer.onHandRenderingEnded(matrixStack_1);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V", shift=At.Shift.AFTER)})
    private void onRightBeforeHandRendering(float tickDelta, long limitTime, PoseStack matrix, CallbackInfo ci) {
        IPCGlobal.renderer.onBeforeHandRendering(matrix);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;resize(II)V"}, at={@At(value="RETURN")})
    private void onOnResized(int int_1, int int_2, CallbackInfo ci) {
        if (ClientWorldLoader.getIsInitialized()) {
            ClientWorldLoader.worldRendererMap.values().stream().filter(worldRenderer -> worldRenderer != this.f_109059_.f_91060_).forEach(worldRenderer -> worldRenderer.m_109487_(int_1, int_2));
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderItemInHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="HEAD")})
    private void onRenderHandBegins(PoseStack matrices, Camera camera, float tickDelta, CallbackInfo ci) {
        portal_isRenderingHand = true;
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderItemInHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="RETURN")})
    private void onRenderHandEnds(PoseStack matrices, Camera camera, float tickDelta, CallbackInfo ci) {
        portal_isRenderingHand = false;
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V"))
    private void redirectBobViewTranslate(PoseStack matrixStack, double x, double y, double z) {
        if (portal_isRenderingHand) {
            matrixStack.m_85837_(x, y, z);
        } else {
            double multiplier = RenderStates.getViewBobbingOffsetMultiplier();
            matrixStack.m_85837_(x * multiplier, y * multiplier, z * multiplier);
        }
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/client/renderer/GameRenderer;getProjectionMatrix(D)Lcom/mojang/math/Matrix4f;"))
    private Matrix4f redirectGetBasicProjectionMatrix(GameRenderer instance, double fov) {
        Matrix4f result;
        if (PortalRendering.isRendering()) {
            if (RenderStates.basicProjectionMatrix != null) {
                return RenderStates.basicProjectionMatrix;
            }
            Helper.err("projection matrix state abnormal");
        }
        RenderStates.basicProjectionMatrix = result = instance.m_172716_(fov);
        return result;
    }

    @Override
    public void setLightmapTextureManager(LightTexture manager) {
        this.f_109074_ = manager;
    }

    @Override
    public boolean getDoRenderHand() {
        return this.f_109070_;
    }

    @Override
    public void setCamera(Camera camera_) {
        this.f_109054_ = camera_;
    }

    @Override
    public void setIsRenderingPanorama(boolean cond) {
        this.f_109076_ = cond;
    }

    @Override
    public void portal_bobView(PoseStack matrixStack, float tickDelta) {
        this.m_109138_(matrixStack, tickDelta);
    }
}

