/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.List;
import net.minecraft.network.chat.Component;
import qouteall.imm_ptl.core.portal.IntraClusterRelation;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;

public record AnimationView(Portal viewedPortal, Portal animationHolder, IntraClusterRelation relationToHolder) {
    public List<PortalAnimationDriver> getThisSideAnimations() {
        if (this.relationToHolder.isReverse) {
            return this.animationHolder.animation.otherSideAnimations;
        }
        return this.animationHolder.animation.thisSideAnimations;
    }

    public List<PortalAnimationDriver> getOtherSideAnimations() {
        if (this.relationToHolder.isReverse) {
            return this.animationHolder.animation.thisSideAnimations;
        }
        return this.animationHolder.animation.otherSideAnimations;
    }

    public PortalAnimationDriver convertToHolderAnimation(PortalAnimationDriver driver) {
        if (this.relationToHolder.isFlipped) {
            return driver.getFlippedVersion();
        }
        return driver;
    }

    public void addThisSideAnimation(PortalAnimationDriver driver) {
        this.getThisSideAnimations().add(this.convertToHolderAnimation(driver));
    }

    public void addOtherSideAnimation(PortalAnimationDriver driver) {
        this.getOtherSideAnimations().add(this.convertToHolderAnimation(driver));
    }

    public Component getInfo() {
        return this.animationHolder.animation.getInfo(this.animationHolder, this.relationToHolder.isReverse);
    }
}

