/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class CustomPortalGeneration {
    public static final ResourceKey<Level> theSameDimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("imm_ptl:the_same_dimension"));
    public static final ResourceKey<Level> anyDimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("imm_ptl:any_dimension"));
    public static final Codec<List<ResourceKey<Level>>> dimensionListCodec = new ListCodec(Level.f_46427_);
    public static final Codec<List<String>> stringListCodec = new ListCodec((Codec)Codec.STRING);
    public static final Codec<List<List<String>>> stringListListCodec = new ListCodec(stringListCodec);
    public static ResourceKey<Registry<Codec<CustomPortalGeneration>>> schemaRegistryKey = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("imm_ptl:custom_portal_gen_schema"));
    public static ResourceKey<Registry<CustomPortalGeneration>> registryRegistryKey = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("imm_ptl:custom_portal_generation"));
    public static final Codec<CustomPortalGeneration> codecV1 = RecordCodecBuilder.create(instance -> instance.group((App)dimensionListCodec.fieldOf("from").forGetter(o -> o.fromDimensions), (App)Level.f_46427_.fieldOf("to").forGetter(o -> o.toDimension), (App)Codec.INT.optionalFieldOf("space_ratio_from", (Object)1).forGetter(o -> o.spaceRatioFrom), (App)Codec.INT.optionalFieldOf("space_ratio_to", (Object)1).forGetter(o -> o.spaceRatioTo), (App)Codec.BOOL.optionalFieldOf("reversible", (Object)true).forGetter(o -> o.reversible), (App)PortalGenForm.codec.fieldOf("form").forGetter(o -> o.form), (App)PortalGenTrigger.triggerCodec.fieldOf("trigger").forGetter(o -> o.trigger), (App)stringListCodec.optionalFieldOf("post_invoke_commands", Collections.emptyList()).forGetter(o -> o.postInvokeCommands), (App)stringListListCodec.optionalFieldOf("commands_on_generated", Collections.emptyList()).forGetter(o -> o.commandsOnGenerated)).apply((Applicative)instance, instance.stable(CustomPortalGeneration::new)));
    public static MappedRegistry<Codec<CustomPortalGeneration>> schemaRegistry = (MappedRegistry)Util.m_137537_(() -> {
        MappedRegistry registry = new MappedRegistry(schemaRegistryKey, Lifecycle.stable(), null);
        Registry.m_122965_((Registry)registry, (ResourceLocation)new ResourceLocation("imm_ptl:v1"), codecV1);
        return registry;
    });
    public static final MapCodec<CustomPortalGeneration> codec = schemaRegistry.m_194605_().dispatchMap("schema_version", e -> codecV1, Function.identity());
    public final List<ResourceKey<Level>> fromDimensions;
    public final ResourceKey<Level> toDimension;
    public final int spaceRatioFrom;
    public final int spaceRatioTo;
    public final boolean reversible;
    public final PortalGenForm form;
    public final PortalGenTrigger trigger;
    public final List<String> postInvokeCommands;
    public final List<List<String>> commandsOnGenerated;
    public ResourceLocation identifier = null;

    public CustomPortalGeneration(List<ResourceKey<Level>> fromDimensions, ResourceKey<Level> toDimension, int spaceRatioFrom, int spaceRatioTo, boolean reversible, PortalGenForm form, PortalGenTrigger trigger, List<String> postInvokeCommands, List<List<String>> commandsOnGenerated) {
        this.fromDimensions = fromDimensions;
        this.toDimension = toDimension;
        this.spaceRatioFrom = spaceRatioFrom;
        this.spaceRatioTo = spaceRatioTo;
        this.reversible = reversible;
        this.form = form;
        this.trigger = trigger;
        this.postInvokeCommands = postInvokeCommands;
        this.commandsOnGenerated = commandsOnGenerated;
    }

    @Nullable
    public CustomPortalGeneration getReverse() {
        if (this.toDimension == theSameDimension) {
            return new CustomPortalGeneration(this.fromDimensions, theSameDimension, this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands, this.commandsOnGenerated);
        }
        if (!this.fromDimensions.isEmpty()) {
            return new CustomPortalGeneration(Lists.newArrayList((Object[])new ResourceKey[]{this.toDimension}), this.fromDimensions.get(0), this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands, this.commandsOnGenerated);
        }
        Helper.err("Cannot get reverse custom portal gen");
        return null;
    }

    public BlockPos mapPosition(BlockPos from, ServerLevel fromWorld, ServerLevel toWorld) {
        BlockPos newPosition = Helper.divide((Vec3i)Helper.scale((Vec3i)from, this.spaceRatioTo), this.spaceRatioFrom);
        boolean withinBounds = toWorld.m_6857_().m_61937_(newPosition);
        if (!withinBounds) {
            Helper.log("Tries to spawn a portal outside of world border");
            BlockPos clamped = toWorld.m_6857_().m_187569_((double)newPosition.m_123341_(), (double)newPosition.m_123342_(), (double)newPosition.m_123343_());
            newPosition = new BlockPos((int)((double)clamped.m_123341_() * 0.9), clamped.m_123342_(), (int)((double)clamped.m_123343_() * 0.9));
        }
        return newPosition;
    }

    public boolean initAndCheck() {
        ResourceKey<Level> toDimension = this.toDimension;
        if (toDimension != theSameDimension && MiscHelper.getServer().m_129880_(toDimension) == null) {
            return false;
        }
        if (!this.form.initAndCheck()) {
            return false;
        }
        return !this.fromDimensions.isEmpty();
    }

    public String toString() {
        return McHelper.serializeToJson(this, codec.codec());
    }

    public boolean perform(ServerLevel world, BlockPos startPos, @Nullable Entity triggeringEntity) {
        ServerLevel toWorld;
        if (!this.fromDimensions.contains(world.m_46472_()) && this.fromDimensions.get(0) != anyDimension) {
            return false;
        }
        if (!world.m_46805_(startPos)) {
            Helper.log("Skip custom portal generation because chunk not loaded");
            return false;
        }
        ResourceKey destDimension = this.toDimension;
        if (destDimension == theSameDimension) {
            destDimension = world.m_46472_();
        }
        if ((toWorld = MiscHelper.getServer().m_129880_(destDimension)) == null) {
            Helper.err("Missing dimension " + destDimension.m_135782_());
            return false;
        }
        world.m_46473_().m_6180_("custom_portal_gen_perform");
        boolean result = this.form.perform(this, world, startPos, toWorld, triggeringEntity);
        world.m_46473_().m_7238_();
        return result;
    }

    public void onPortalsGenerated(Portal[] portals) {
        for (int i = 0; i < portals.length; ++i) {
            Portal portal = portals[i];
            if (this.identifier != null) {
                portal.portalTag = this.identifier.toString();
            }
            if (!this.postInvokeCommands.isEmpty()) {
                McHelper.invokeCommandAs(portal, this.postInvokeCommands);
            }
            if (i >= this.commandsOnGenerated.size()) continue;
            List<String> commandsForThisPortal = this.commandsOnGenerated.get(i);
            McHelper.invokeCommandAs(portal, commandsForThisPortal);
        }
    }
}

