/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.portal_generation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.PortalShape;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.peripheral.portal_generation.DiligentNetherPortalForm;
import qouteall.imm_ptl.peripheral.portal_generation.IntrinsicNetherPortalForm;
import qouteall.imm_ptl.peripheral.portal_generation.PortalHelperForm;

public class IntrinsicPortalGeneration {
    public static final IntrinsicNetherPortalForm intrinsicNetherPortalForm = new IntrinsicNetherPortalForm();
    public static final DiligentNetherPortalForm diligentNetherPortalForm = new DiligentNetherPortalForm();
    public static final PortalHelperForm portalHelperForm = new PortalHelperForm();
    public static final CustomPortalGeneration intrinsicToNether = new CustomPortalGeneration(Lists.newArrayList((Object[])new ResourceKey[]{Level.f_46428_}), (ResourceKey<Level>)Level.f_46429_, 8, 1, true, intrinsicNetherPortalForm, null, new ArrayList<String>(), new ArrayList<List<String>>());
    public static final CustomPortalGeneration intrinsicFromNether = intrinsicToNether.getReverse();
    public static final CustomPortalGeneration diligentToNether = new CustomPortalGeneration(Lists.newArrayList((Object[])new ResourceKey[]{Level.f_46428_}), (ResourceKey<Level>)Level.f_46429_, 8, 1, true, diligentNetherPortalForm, null, new ArrayList<String>(), new ArrayList<List<String>>());
    public static final CustomPortalGeneration diligentFromNether = diligentToNether.getReverse();
    public static final CustomPortalGeneration portalHelper = new CustomPortalGeneration(Lists.newArrayList((Object[])new ResourceKey[]{CustomPortalGeneration.anyDimension}), CustomPortalGeneration.theSameDimension, 1, 1, false, portalHelperForm, null, new ArrayList<String>(), new ArrayList<List<String>>());

    public static void init() {
        IntrinsicPortalGeneration.intrinsicToNether.identifier = new ResourceLocation("imm_ptl:intrinsic_nether_portal");
        IntrinsicPortalGeneration.intrinsicFromNether.identifier = new ResourceLocation("imm_ptl:intrinsic_nether_portal");
        IntrinsicPortalGeneration.diligentFromNether.identifier = new ResourceLocation("imm_ptl:intrinsic_diligent_nether_portal");
        IntrinsicPortalGeneration.diligentToNether.identifier = new ResourceLocation("imm_ptl:intrinsic_diligent_nether_portal");
        IntrinsicPortalGeneration.portalHelper.identifier = new ResourceLocation("imm_ptl:intrinsic_portal_helper");
    }

    public static boolean onFireLitOnObsidian(ServerLevel fromWorld, BlockPos firePos) {
        ResourceKey fromDimension = fromWorld.m_46472_();
        if (fromDimension == Level.f_46428_) {
            CustomPortalGeneration gen = IPGlobal.netherPortalMode == IPGlobal.NetherPortalMode.normal ? intrinsicToNether : diligentToNether;
            return gen.perform(fromWorld, firePos, null);
        }
        if (fromDimension == Level.f_46429_) {
            CustomPortalGeneration gen = IPGlobal.netherPortalMode == IPGlobal.NetherPortalMode.normal ? intrinsicFromNether : diligentFromNether;
            return gen.perform(fromWorld, firePos, null);
        }
        return false;
    }

    public static boolean activatePortalHelper(ServerLevel fromWorld, BlockPos firePos) {
        return portalHelper.perform(fromWorld, firePos, null);
    }

    public static boolean onCrouchingPlayerIgnite(ServerLevel world, ServerPlayer player, BlockPos firePos) {
        boolean dimensionCorrect;
        if (IPGlobal.netherPortalMode == IPGlobal.NetherPortalMode.disabled) {
            return false;
        }
        if (!IPGlobal.lightVanillaNetherPortalWhenCrouching) {
            return false;
        }
        boolean bl = dimensionCorrect = world.m_46472_() == Level.f_46428_ || world.m_46472_() == Level.f_46429_;
        if (!dimensionCorrect) {
            return false;
        }
        Optional newPortal = PortalShape.m_77708_((LevelAccessor)world, (BlockPos)firePos, (Direction.Axis)Direction.Axis.X);
        if (newPortal.isEmpty()) {
            return false;
        }
        PortalShape areaHelper = (PortalShape)newPortal.get();
        areaHelper.m_77743_();
        return true;
    }
}

