/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimensionIdRecord;
import qouteall.q_misc_util.dimension.DimensionTypeSync;
import qouteall.q_misc_util.forge.events.ClientDimensionUpdateEvent;
import qouteall.q_misc_util.mixin.client.IEClientPacketListener_Misc;

public class MiscNetworking {
    public static final ResourceLocation id_stcRemote = new ResourceLocation("imm_ptl", "remote_stc");
    public static final ResourceLocation id_ctsRemote = new ResourceLocation("imm_ptl", "remote_cts");
    public static final ResourceLocation id_stcDimSync = new ResourceLocation("imm_ptl", "dim_sync");

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
    }

    public static void init() {
    }

    public static Packet createDimSyncPacket() {
        Validate.notNull((Object)DimensionIdRecord.serverRecord);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag idMapTag = DimensionIdRecord.recordToTag(DimensionIdRecord.serverRecord, dim -> MiscHelper.getServer().m_129880_(dim) != null);
        buf.m_130079_(idMapTag);
        CompoundTag typeMapTag = DimensionTypeSync.createTagFromServerWorldInfo();
        buf.m_130079_(typeMapTag);
        return new ClientboundCustomPayloadPacket(id_stcDimSync, buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processDimSync(FriendlyByteBuf buf, ClientPacketListener packetListener) {
        CompoundTag idMap = buf.m_130260_();
        DimensionIdRecord.clientRecord = DimensionIdRecord.tagToRecord(idMap);
        CompoundTag typeMap = buf.m_130260_();
        MiscHelper.executeOnRenderThread(() -> {
            DimensionTypeSync.acceptTypeMapData(typeMap);
            Helper.log("Received Dimension Int Id Sync");
            Helper.log("\n" + DimensionIdRecord.clientRecord);
            Set<ResourceKey<Level>> dimIdSet = DimensionIdRecord.clientRecord.getDimIdSet();
            ((IEClientPacketListener_Misc)packetListener).ip_setLevels(dimIdSet);
            MinecraftForge.EVENT_BUS.post((Event)new ClientDimensionUpdateEvent(dimIdSet));
        });
    }
}

