/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public interface IControllableStorage
extends IControllerBoundable {
    public IStorageWrapper getStorageWrapper();

    default public boolean canBeConnected() {
        return this.getControllerPos().isEmpty();
    }

    @Override
    default public boolean canConnectStorages() {
        return true;
    }

    default public void tryToAddToController() {
        this.addToAdjacentController();
    }

    default public void removeFromController() {
        Level level = this.getStorageBlockLevel();
        if (!level.m_5776_()) {
            this.getControllerPos().flatMap(p -> WorldHelper.getBlockEntity((BlockGetter)level, p, ControllerBlockEntityBase.class)).ifPresent(c -> c.removeStorage(this.getStorageBlockPos()));
            this.removeControllerPos();
        }
    }

    private void addToAdjacentController() {
        Level level = this.getStorageBlockLevel();
        if (!level.m_5776_()) {
            BlockPos pos = this.getStorageBlockPos();
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.m_121955_(dir.m_122436_());
                WorldHelper.getBlockEntity((BlockGetter)level, offsetPos, IControllableStorage.class).ifPresentOrElse(s -> {
                    if (s.canConnectStorages()) {
                        s.getControllerPos().ifPresent(controllerPos -> this.addToController(level, pos, (BlockPos)controllerPos));
                    }
                }, () -> this.addToController(level, pos, offsetPos));
                if (this.getControllerPos().isPresent()) break;
            }
        }
    }

    private void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
        WorldHelper.getBlockEntity((BlockGetter)level, controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    default public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.m_58899_());
        this.registerListeners();
    }

    default public void unregisterController() {
        this.removeControllerPos();
        this.getStorageWrapper().getInventoryForInputOutput().unregisterStackKeyListeners();
        this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).unregisterListeners();
        this.getStorageWrapper().getInventoryHandler().unregisterFilterItemsChangeListener();
    }

    private void registerListeners() {
        this.registerInventoryStackListeners();
        this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).registerListeners(i -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.addStorageMemorizedItem(this.getStorageBlockPos(), (Item)i)), i -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.removeStorageMemorizedItem(this.getStorageBlockPos(), (Item)i)), i -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.addStorageMemorizedStack(this.getStorageBlockPos(), (int)i)), i -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.removeStorageMemorizedStack(this.getStorageBlockPos(), (int)i)));
        this.getStorageWrapper().getInventoryHandler().registerFilterItemsChangeListener(items -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.setStorageFilterItems(this.getStorageBlockPos(), (Set<Item>)items)));
    }

    default public void registerInventoryStackListeners() {
        this.getStorageWrapper().getInventoryForInputOutput().registerTrackingListeners(isk -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.addStorageStack(this.getStorageBlockPos(), (ItemStackKey)isk)), isk -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.removeStorageStack(this.getStorageBlockPos(), (ItemStackKey)isk)), () -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.addStorageWithEmptySlots(this.getStorageBlockPos())), () -> this.runOnController(this.getStorageBlockLevel(), controller -> controller.removeStorageWithEmptySlots(this.getStorageBlockPos())));
    }

    default public void registerWithControllerOnLoad() {
        this.getControllerPos().ifPresent(controllerPos -> {
            Level level = this.getStorageBlockLevel();
            if (!level.m_5776_()) {
                WorldHelper.getLoadedBlockEntity(level, controllerPos, ControllerBlockEntityBase.class).ifPresent(controller -> controller.addStorageStacksAndRegisterListeners(this.getStorageBlockPos()));
            }
        });
    }

    default public void changeSlots(int newSlots) {
        this.getControllerPos().ifPresent(controllerPos -> {
            Level level = this.getStorageBlockLevel();
            if (!level.m_5776_()) {
                WorldHelper.getLoadedBlockEntity(level, controllerPos, ControllerBlockEntityBase.class).ifPresent(controller -> controller.changeSlots(this.getStorageBlockPos(), newSlots, this.getStorageWrapper().getInventoryForInputOutput().hasEmptySlots()));
            }
        });
    }

    default public void updateEmptySlots() {
        this.getControllerPos().ifPresent(controllerPos -> {
            Level level = this.getStorageBlockLevel();
            if (!level.m_5776_()) {
                WorldHelper.getLoadedBlockEntity(level, controllerPos, ControllerBlockEntityBase.class).ifPresent(controller -> controller.updateEmptySlots(this.getStorageBlockPos(), this.getStorageWrapper().getInventoryForInputOutput().hasEmptySlots()));
            }
        });
    }
}

