/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.gui.immersiveLibrary;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import fabric.net.mca.MCA;
import fabric.net.mca.client.gui.immersiveLibrary.Api;
import fabric.net.mca.client.gui.immersiveLibrary.responses.ContentListResponse;
import fabric.net.mca.client.gui.immersiveLibrary.responses.ContentResponse;
import fabric.net.mca.client.gui.immersiveLibrary.responses.Response;
import fabric.net.mca.client.gui.immersiveLibrary.types.LiteContent;
import fabric.net.mca.client.resources.SkinMeta;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.FileUtils;

public class SkinCache {
    private static final class_2960 DEFAULT_SKIN = MCA.locate("skins/empty.png");
    private static final Gson gson = new Gson();
    static final Map<Integer, Boolean> requested = new ConcurrentHashMap<Integer, Boolean>();
    static final Map<Integer, class_2960> textureIdentifiers = new HashMap<Integer, class_2960>();
    static final Map<Integer, class_1011> images = new HashMap<Integer, class_1011>();
    static final Map<Integer, SkinMeta> metaCache = new HashMap<Integer, SkinMeta>();
    private static final List<LiteContent> content = new ArrayList<LiteContent>();
    private static final Map<Integer, LiteContent> contentLookup = new HashMap<Integer, LiteContent>();

    private static File getFile(String key) {
        new File("./immersive_library/").mkdirs();
        return new File("./immersive_library/" + key);
    }

    private static void write(String file, String content) {
        try {
            FileUtils.writeStringToFile((File)SkinCache.getFile(file), (String)content, (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void write(String file, byte[] content) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(SkinCache.getFile(file)));){
            ((OutputStream)out).write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String read(String file) {
        try {
            return FileUtils.readFileToString((File)SkinCache.getFile(file), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void enforceSync(int contentid) {
        SkinCache.getFile(contentid + ".version").delete();
    }

    public static void sync(LiteContent content) {
        SkinCache.sync(content.contentid(), content.version());
    }

    public static void sync(int contentid, int currentVersion) {
        if (!requested.containsKey(contentid)) {
            requested.put(contentid, true);
            int version = -1;
            try {
                String s = FileUtils.readFileToString((File)SkinCache.getFile(contentid + ".version"), (Charset)Charset.defaultCharset());
                version = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (currentVersion == version) {
                SkinCache.loadResources(contentid);
            } else if (currentVersion >= 0) {
                SkinCache.getFile(contentid + ".version").delete();
                CompletableFuture.runAsync(() -> {
                    Response response = Api.request(Api.HttpMethod.GET, ContentResponse.class, "content/mca/%s".formatted(contentid));
                    if (response instanceof ContentResponse) {
                        ContentResponse contentResponse = (ContentResponse)response;
                        SkinCache.write(contentid + ".png", Base64.getDecoder().decode(contentResponse.content().data()));
                        SkinCache.write(contentid + ".json", contentResponse.content().meta());
                        SkinCache.write(contentid + ".version", Integer.toString(contentResponse.content().version()));
                        requested.remove(contentid);
                    }
                });
            }
        }
    }

    private static void loadResources(int contentid) {
        try {
            String json = SkinCache.read(contentid + ".json");
            SkinMeta meta = (SkinMeta)gson.fromJson(json, SkinMeta.class);
            metaCache.put(contentid, meta);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            SkinCache.enforceSync(contentid);
        }
        try (FileInputStream stream = new FileInputStream(SkinCache.getFile(contentid + ".png").getPath());){
            class_1011 image = class_1011.method_4309((InputStream)stream);
            class_2960 identifier = new class_2960("immersive_library", String.valueOf(contentid));
            class_310.method_1551().method_1531().method_4616(identifier, (class_1044)new class_1043(image));
            textureIdentifiers.put(contentid, identifier);
            images.put(contentid, image);
        }
        catch (IOException e) {
            e.printStackTrace();
            SkinCache.enforceSync(contentid);
        }
    }

    public static Optional<SkinMeta> getMeta(LiteContent content) {
        SkinCache.sync(content);
        return Optional.ofNullable(metaCache.get(content.contentid()));
    }

    public static Optional<class_1011> getImage(LiteContent content) {
        SkinCache.sync(content);
        return Optional.ofNullable(images.get(content.contentid()));
    }

    public static class_2960 getTextureIdentifier(LiteContent content) {
        SkinCache.sync(content);
        return textureIdentifiers.getOrDefault(content.contentid(), DEFAULT_SKIN);
    }

    public static class_2960 getTextureIdentifier(int contentid) {
        SkinCache.sync(contentid, contentLookup.containsKey(contentid) ? contentLookup.get(contentid).version() : -2);
        return textureIdentifiers.getOrDefault(contentid, DEFAULT_SKIN);
    }

    public static void setContent(List<LiteContent> content) {
        requested.clear();
        SkinCache.content.clear();
        SkinCache.content.addAll(content);
        contentLookup.clear();
        for (LiteContent liteContent : content) {
            contentLookup.put(liteContent.contentid(), liteContent);
        }
    }

    public static List<LiteContent> getContent() {
        return content;
    }

    static {
        CompletableFuture.runAsync(() -> {
            Response response = Api.request(Api.HttpMethod.GET, ContentListResponse.class, "content/mca");
            if (response instanceof ContentListResponse) {
                ContentListResponse contentListResponse = (ContentListResponse)response;
                SkinCache.setContent(List.of(contentListResponse.contents()));
            }
        });
    }
}

