/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.gui.immersiveLibrary;

import fabric.net.mca.client.gui.SkinLibraryScreen;
import fabric.net.mca.client.gui.immersiveLibrary.types.LiteContent;
import fabric.net.mca.client.resources.SkinMeta;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.resources.data.skin.Clothing;
import fabric.net.mca.resources.data.skin.Hair;
import fabric.net.mca.resources.data.skin.SkinListEntry;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_3532;

public final class Workspace {
    private static final int MAX_HISTORY = 50;
    public SkinLibraryScreen.SkinType skinType;
    public int contentid = -1;
    public int temperature;
    public double chance = 1.0;
    public String title = "Unnamed Asset";
    public String profession;
    public Gender gender = Gender.NEUTRAL;
    public int fillToolThreshold = 32;
    public final class_1011 currentImage;
    public final class_1043 backendTexture;
    public LinkedList<class_1011> history = new LinkedList();
    private boolean dirty;
    private boolean dirtySinceSnapshot;

    public Workspace(class_1011 image) {
        this.currentImage = image;
        this.backendTexture = new class_1043(this.currentImage);
        this.dirty = true;
    }

    public Workspace(class_1011 image, SkinMeta meta, LiteContent content) {
        this(image);
        this.contentid = content.contentid();
        this.title = content.title();
        this.skinType = content.hasTag("clothing") ? SkinLibraryScreen.SkinType.CLOTHING : SkinLibraryScreen.SkinType.HAIR;
        this.chance = meta.getChance();
        this.gender = meta.getGender();
        this.profession = meta.getProfession();
        this.temperature = meta.getTemperature();
    }

    public SkinListEntry toListEntry() {
        if (this.skinType == SkinLibraryScreen.SkinType.CLOTHING) {
            return new Clothing("immersive_library:" + this.contentid, this.profession, this.temperature, false, this.gender);
        }
        return new Hair("immersive_library:" + this.contentid);
    }

    private void fillDeleteFunc(FillTodo entry, Queue<FillTodo> todo, int x, int y) {
        if (x < 0 || y < 0 || x >= 64 || y >= 64) {
            return;
        }
        FillTodo nextEntry = new FillTodo(x, y, this.currentImage.method_35623(x, y), this.currentImage.method_35625(x, y), this.currentImage.method_35626(x, y), this.currentImage.method_4311(x, y));
        if (Math.abs(nextEntry.red - entry.red) > this.fillToolThreshold) {
            return;
        }
        if (Math.abs(nextEntry.green - entry.green) > this.fillToolThreshold) {
            return;
        }
        if (Math.abs(nextEntry.blue - entry.blue) > this.fillToolThreshold) {
            return;
        }
        if (Math.abs(nextEntry.alpha - entry.alpha) > this.fillToolThreshold) {
            return;
        }
        todo.add(nextEntry);
    }

    public void removeSaturation() {
        this.saveSnapshot(true);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int r = this.currentImage.method_35623(x, y) & 0xFF;
                int g = this.currentImage.method_35625(x, y) & 0xFF;
                int b = this.currentImage.method_35626(x, y) & 0xFF;
                int a = this.currentImage.method_4311(x, y) & 0xFF;
                int l = class_3532.method_15340((int)((int)(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b)), (int)0, (int)255);
                this.currentImage.method_4305(x, y, a << 24 | l << 16 | l << 8 | l);
            }
        }
        this.dirty = true;
    }

    public void addBrightness(int i) {
        this.saveSnapshot(true);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int r = class_3532.method_15340((int)((this.currentImage.method_35623(x, y) & 0xFF) + i), (int)0, (int)255);
                int g = class_3532.method_15340((int)((this.currentImage.method_35625(x, y) & 0xFF) + i), (int)0, (int)255);
                int b = class_3532.method_15340((int)((this.currentImage.method_35626(x, y) & 0xFF) + i), (int)0, (int)255);
                int a = this.currentImage.method_4311(x, y) & 0xFF;
                this.currentImage.method_4305(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        this.dirty = true;
    }

    public void addContrast(float c) {
        int y;
        int x;
        this.saveSnapshot(true);
        int average = 0;
        int samples = 0;
        for (x = 0; x < 64; ++x) {
            for (y = 0; y < 64; ++y) {
                int a = this.currentImage.method_4311(x, y) & 0xFF;
                if (a <= 0) continue;
                average += this.currentImage.method_35623(x, y) & 0xFF;
                average += this.currentImage.method_35626(x, y) & 0xFF;
                average += this.currentImage.method_35625(x, y) & 0xFF;
                samples += 3;
            }
        }
        average /= samples;
        for (x = 0; x < 64; ++x) {
            for (y = 0; y < 64; ++y) {
                int r = class_3532.method_15340((int)((int)((float)((this.currentImage.method_35623(x, y) & 0xFF) - average) * (1.0f + c) + (float)average)), (int)0, (int)255);
                int g = class_3532.method_15340((int)((int)((float)((this.currentImage.method_35625(x, y) & 0xFF) - average) * (1.0f + c) + (float)average)), (int)0, (int)255);
                int b = class_3532.method_15340((int)((int)((float)((this.currentImage.method_35626(x, y) & 0xFF) - average) * (1.0f + c) + (float)average)), (int)0, (int)255);
                int a = this.currentImage.method_4311(x, y) & 0xFF;
                this.currentImage.method_4305(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        this.dirty = true;
    }

    public void fillDelete(int x, int y) {
        if (x < 0 || y < 0 || x >= 64 || y >= 64) {
            return;
        }
        this.saveSnapshot(true);
        LinkedList<FillTodo> todo = new LinkedList<FillTodo>();
        todo.add(new FillTodo(x, y, this.currentImage.method_35623(x, y), this.currentImage.method_35625(x, y), this.currentImage.method_35626(x, y), this.currentImage.method_4311(x, y)));
        while (!todo.isEmpty()) {
            FillTodo entry = (FillTodo)todo.poll();
            if (this.currentImage.method_4311(entry.x, entry.y) == 0) continue;
            this.currentImage.method_4305(entry.x, entry.y, 0);
            this.dirty = true;
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    if (ox == 0 && oy == 0) continue;
                    this.fillDeleteFunc(entry, todo, entry.x + ox, entry.y + oy);
                }
            }
        }
    }

    public boolean validPixel(int x, int y) {
        return x >= 0 && x < 64 && y >= 0 && y < 64;
    }

    public void saveSnapshot(boolean always) {
        if (always || this.dirtySinceSnapshot) {
            this.dirtySinceSnapshot = false;
            while (this.history.size() > 50) {
                this.history.removeFirst().close();
            }
            class_1011 image = new class_1011(64, 64, false);
            image.method_4317(this.currentImage);
            this.history.add(image);
        }
    }

    public void undo() {
        if (this.history.size() > 0) {
            class_1011 image = this.history.removeLast();
            this.currentImage.method_4317(image);
            image.close();
            this.dirty = true;
            this.dirtySinceSnapshot = false;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.dirtySinceSnapshot = true;
        }
    }

    private record FillTodo(int x, int y, int red, int green, int blue, int alpha) {
    }
}

