/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.c2s.FamilyTreeUUIDLookup;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FamilyTreeSearchScreen
extends Screen {
    static final int DATA_WIDTH = 120;
    private List<Entry> list = new LinkedList<Entry>();
    private Button buttonPage;
    private int pageNumber;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;
    private String currentVillagerName = "";

    public FamilyTreeSearchScreen() {
        super((Component)Component.m_237115_((String)"gui.family_tree.title"));
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        EditBox field = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 60, this.f_96544_ / 2 - 80, 120, 18, (Component)Component.m_237115_((String)"structure_block.structure_name")));
        field.m_94199_(32);
        field.m_94151_(this::searchVillager);
        field.m_94178_(true);
        this.m_7522_((GuiEventListener)field);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 44, this.f_96544_ / 2 + 82, 88, 20, (Component)Component.m_237115_((String)"gui.done"), sender -> this.m_7379_()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 24 - 20, this.f_96544_ / 2 + 60, 20, 20, (Component)Component.m_237113_((String)"<"), b -> {
            if (this.pageNumber > 0) {
                --this.pageNumber;
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 24, this.f_96544_ / 2 + 60, 20, 20, (Component)Component.m_237113_((String)">"), b -> {
            if ((double)this.pageNumber < Math.ceil((double)this.list.size() / 9.0) - 1.0) {
                ++this.pageNumber;
            }
        }));
        this.buttonPage = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 24, this.f_96544_ / 2 + 60, 48, 20, (Component)Component.m_237113_((String)"0/0)"), b -> {}));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        assert (this.f_96541_ != null);
        this.mouseX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96543_ / (double)this.f_96541_.m_91268_().m_85441_());
        this.mouseY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96544_ / (double)this.f_96541_.m_91268_().m_85442_());
        FamilyTreeSearchScreen.m_93172_((PoseStack)matrices, (int)(this.f_96543_ / 2 - 60 - 10), (int)(this.f_96544_ / 2 - 110), (int)(this.f_96543_ / 2 + 60 + 10), (int)(this.f_96544_ / 2 + 110), (int)0x66000000);
        this.m_7333_(matrices);
        this.renderVillagers(matrices);
        FamilyTreeSearchScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.title.family_tree"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 100), (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private void renderVillagers(PoseStack transform) {
        int index;
        int maxPages = (int)Math.ceil((double)this.list.size() / 9.0);
        this.buttonPage.m_93666_((Component)Component.m_237113_((String)(this.pageNumber + 1 + "/" + maxPages)));
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < this.list.size(); ++i) {
            int y = this.f_96544_ / 2 - 52 + i * 12;
            boolean hover = this.isMouseWithin(this.f_96543_ / 2 - 50, y - 1, 100, 12);
            Entry entry = this.list.get(index);
            MutableComponent text = MCA.isBlankString(entry.mother) && MCA.isBlankString(entry.father) ? Component.m_237115_((String)"gui.family_tree.child_of_0") : (MCA.isBlankString(entry.mother) ? Component.m_237110_((String)"gui.family_tree.child_of_1", (Object[])new Object[]{entry.father}) : (MCA.isBlankString(entry.father) ? Component.m_237110_((String)"gui.family_tree.child_of_1", (Object[])new Object[]{entry.mother}) : Component.m_237110_((String)"gui.family_tree.child_of_2", (Object[])new Object[]{entry.father, entry.mother})));
            FamilyTreeSearchScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)text, (int)(this.f_96543_ / 2), (int)y, (int)(hover ? -2631804 : -1));
            if (!hover) continue;
            this.selectedVillager = entry.uuid;
        }
    }

    private void searchVillager(String v) {
        if (!MCA.isBlankString(v)) {
            NetworkHandler.sendToServer(new FamilyTreeUUIDLookup(v));
        }
        this.currentVillagerName = v;
    }

    public void setList(List<Entry> list) {
        this.list = list;
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selectedVillager != null) {
            this.selectVillager(this.currentVillagerName, this.selectedVillager);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    void selectVillager(String name, UUID villager) {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_((Screen)new FamilyTreeScreen(villager));
    }

    public record Entry(UUID uuid, String father, String mother) implements Serializable
    {
    }
}

